#!/bin/bash

# Docker 설치 여부 확인
if ! command -v docker &> /dev/null; then
    echo "Docker가 설치되어 있지 않습니다."
    echo "설치 방법:"
    echo "sudo apt-get update"
    echo "sudo apt-get install docker.io"
    echo "sudo systemctl start docker"
    echo "sudo systemctl enable docker"
    exit 1
fi

# Docker Compose 설치 여부 확인
if ! command -v docker-compose &> /dev/null; then
    echo "Docker Compose가 설치되어 있지 않습니다."
    echo "설치 방법:"
    echo "sudo apt-get install docker-compose"
    echo "또는"
    echo "sudo curl -L \"https://github.com/docker/compose/releases/latest/download/docker-compose-\$(uname -s)-\$(uname -m)\" -o /usr/local/bin/docker-compose"
    echo "sudo chmod +x /usr/local/bin/docker-compose"
    exit 1
fi

cd langfuse

if [ "$1" == "stop" ]; then
    docker compose down
    echo "Langfuse 서비스가 중지되었습니다."
else
    docker compose up -d 
    echo "Langfuse 서비스가 시작되었습니다."
    echo "접속 URL: http://localhost:3002"
    echo ""
fi

cd ..

exit 0 