#!/bin/bash

# 색상 정의
GREEN='\033[0;32m'
NC='\033[0m'

# 프로젝트 경로 찾기
PROJECT_PATH=$(pwd)
NVM_DIR="$HOME/.nvm"

# XDG 환경 변수 확인 및 기본값 설정
if [[ -z "$XDG_DESKTOP_DIR" ]]; then
    XDG_DESKTOP_DIR="$HOME/Desktop"
fi

# 데스크톱 파일과 아이콘 설치
mkdir -p "$XDG_DESKTOP_DIR"
cp assets/airun.desktop "$XDG_DESKTOP_DIR/"

# 아이콘 설치
ICON_DIR="$HOME/.local/share/icons"
mkdir -p "$ICON_DIR"
cp assets/airun.png "$ICON_DIR/"

# 데스크톱 파일의 아이콘 경로와 Exec 경로 수정
sed -i "s|Icon=airun.png|Icon=$ICON_DIR/airun.png|g" "$XDG_DESKTOP_DIR/airun.desktop"
sed -i "s|Exec=.*|Exec=/usr/bin/zsh -i -c \"cd $PROJECT_PATH \&\& source $NVM_DIR/nvm.sh \&\& NODE_ENV=production airun -g\"|g" "$XDG_DESKTOP_DIR/airun.desktop"

# 실행 권한 설정
chmod +x "$XDG_DESKTOP_DIR/airun.desktop"

# 애플리케이션 메뉴에도 설치
APP_DIR="$HOME/.local/share/applications"
mkdir -p "$APP_DIR"
cp "$XDG_DESKTOP_DIR/airun.desktop" "$APP_DIR/"

# 캐시 갱신
update-desktop-database ~/.local/share/applications

echo -e "${GREEN}데스크톱 파일이 설치되었습니다.${NC}"
