#!/bin/bash

# PDF 문서 테스트
echo "PDF 문서 생성 테스트 시작..."
airun "examples/data/sample.txt 파일의 내용을 읽어서 제목, 부제목, 본문으로 구성된 PDF 문서를 생성하고 examples/data/output/output.pdf로 저장해주세요."
echo "PDF 표 생성 테스트 시작..."
airun "examples/data/data.csv 파일을 읽어서 표로 변환하고 제목과 함께 PDF 문서로 저장해주세요. 파일명은 examples/data/output/table_report.pdf로 해주세요."
echo "PDF 이미지 삽입 테스트 시작..."
airun "examples/data/sample.jpg 이미지를 가로 500픽셀 크기로 리사이즈하고, 제목과 함께 PDF 문서에 삽입하여 examples/data/output/image_report.pdf로 저장해주세요."

# HWP 문서 테스트
echo "HWP 문서 생성 테스트 시작..."
airun "제목은 '테스트 문서', 본문은 '이것은 테스트입니다.'라는 내용으로 HWP 문서를 생성하고 examples/data/output/test.hwp로 저장해주세요."
echo "HWP 표 생성 테스트 시작..."
airun "examples/data/data.csv 파일의 데이터로 HWP 문서를 생성하고, HWPDocument 클래스의 add_heading 메소드로 'CSV 데이터 테이블'이라는 제목을 추가한 후, add_table 메소드를 사용하여 표를 삽입하고 examples/data/output/table_test.hwp로 저장해주세요."

# 번역 테스트
echo "영어 번역 테스트 시작..."
airun "examples/data/korean.txt 파일의 내용을 TextProcessor 클래스의 translate 메소드를 사용하여 영어로 번역하고 결과를 examples/data/output/english.txt 파일로 저장해주세요."
echo "다국어 번역 테스트 시작..."
airun "examples/data/korean.txt 파일의 내용을 TextProcessor 클래스의 translate 메소드를 사용하여 일본어, 중국어, 프랑스어로 번역하고 각각 examples/data/output/japanese.txt, examples/data/output/chinese.txt, examples/data/output/french.txt 파일로 저장해주세요."

# AI 기능 테스트
echo "AI 텍스트 요약 테스트 시작..."
airun "examples/data/korean.txt 파일의 내용을 TextProcessor 클래스의 summarize 메소드를 사용하여 200자 이내로 요약하고, 결과를 examples/data/output/summary.txt 파일로 저장해주세요."
echo "AI 코드 리뷰 테스트 시작..."
airun "examples/data/source_code.py 파일의 코드를 TextProcessor 클래스의 review_code 메소드를 사용하여 리뷰하고 결과를 examples/data/output/code_review.txt 파일로 저장해주세요."

# Matplotlib 테스트
echo "Matplotlib 기본 그래프 테스트 시작..."
airun "examples/data/data.csv 파일의 데이터로 선 그래프를 생성하고 한글 제목, 축 이름을 포함하여 examples/data/output/line_plot.png로 저장해주세요."
echo "Matplotlib 파이 차트 테스트 시작..."
airun "examples/data/categories.csv 파일의 데이터를 사용하여 파이 차트를 생성해주세요. '카테고리' 열의 값을 레이블로, '비율' 열의 값을 데이터로 사용하고, 한글 범례를 포함하여 examples/data/output/pie_chart.png로 저장해주세요."

# 이미지 처리 테스트
echo "이미지 RGB 변환 테스트 시작..."
airun "examples/data/transparent.png 파일을 RGB 형식으로 변환하고 examples/data/output/rgb_image.png로 저장해주세요."
echo "이미지 리사이즈 테스트 시작..."
airun "examples/data/large_image.jpg 파일을 가로 1024픽셀 크기로 비율을 유지하여 리사이즈하고 examples/data/output/resized_image.jpg로 저장해주세요."

# 웹 검색 테스트
echo "멀티 포털 검색 테스트 시작..."
airun "네이버, 구글, 다음에서 'Python 프로그래밍'을 검색하고 각각 상위 3개 결과를 examples/data/output/search_results.txt 파일로 저장해주세요."
echo "유튜브 검색 테스트 시작..."
airun "유튜브에서 '파이썬 강좌'를 검색하고 상위 5개 결과의 제목과 URL을 examples/data/output/youtube_results.txt 파일로 저장해주세요."

# 파일 시스템 테스트
echo "파일 정보 추출 테스트 시작..."
airun "examples/data 디렉토리의 모든 파일에 대해 크기, 수정일자, 권한 정보를 추출하여 examples/data/output/file_info.txt 파일로 저장해주세요. 각 파일의 정보는 '파일명: [이름], 크기: [크기] bytes, 수정일자: [modified_time], 권한: [permissions]' 형식으로 저장해주세요."
echo "파일 검색 테스트 시작..."
airun "examples/data 디렉토리에서 '김철수' 가 포함된 모든 문서 파일(txt, pdf, doc, xls)을 찾아서 목록을 examples/data/output/search_results.txt 파일로 저장해주세요."

# 이메일 테스트
echo "이메일 발송 테스트 시작..."
airun "examples/data/output/report.pdf와 examples/data/output/data.xlsx 파일을 첨부하여 chaeya@gmail.com으로 '테스트 첨부파일'이라는 제목의 이메일을 발송해주세요."

# 시스템 명령어 테스트
echo "시스템 명령어 실행 테스트 시작..."
airun "'df -h' 명령어를 실행하고 결과를 examples/data/output/disk_usage.txt 파일로 저장해주세요."

# 패키지 설치 테스트
echo "패키지 설치 테스트 시작..."
airun "'requests' 패키지가 설치되어 있는지 확인하고, 없다면 설치한 후 설치 결과를 examples/data/output/install_log.txt 파일로 저장해주세요."

echo "모든 테스트가 완료되었습니다." 