# AI.RUN 보고서 생성 기능 (Report Generator)

## 개요

보고서 생성 서비스는 AI 기술을 활용하여 사업계획서, 제안서, 논문 등 다양한 형태의 문서를 자동으로 생성하는 기능을 제공합니다. 사용자가 간단한 개요나 요구사항을 입력하면, 시스템이 자동으로 구조화된 문서를 생성하고 필요에 따라 차트, 표, 다이어그램 등을 포함시킵니다.

## 주요 기능

- **다양한 문서 템플릿 지원**: 사업계획서, 제안서, 마케팅 계획서, 논문 등 다양한 템플릿 제공
- **자동 콘텐츠 생성**: AI를 활용한 섹션별 콘텐츠 자동 생성
- **시각적 요소 생성**: 차트, 표, SWOT 분석, 타임라인, 다이어그램 등 자동 생성
- **웹 검색 통합**: 최신 시장 데이터, 트렌드 정보 등을 웹 검색을 통해 수집하여 반영
- **RAG 기반 정보 검색**: 기존 문서와 데이터베이스에서 관련 정보를 검색하여 정확한 콘텐츠 생성
- **다양한 출력 형식**: PDF, DOCX, HWPX 등 다양한 문서 형식으로 출력 지원
- **자동 템플릿 선택**: 사용자 입력을 분석하여 최적의 템플릿을 자동으로 선택


## Quick Start

```bash
airun --report < 요청파일.txt

또는

airun --report "AI 기반 개인화 학습 플랫폼 개발 사업계획서를 작성해주세요"
```

## 입력 파일 예시

```
AI 기반 개인화 학습 플랫폼 개발 사업계획서를 작성해주세요.

사업 개요:
- 사업명: AI 튜터 - 개인 맞춤형 학습 플랫폼
- 목적: AI 기술을 활용한 1:1 맞춤형 학습 서비스 제공
- 개발 기간: 2024.07 - 2025.06 (12개월)
- 총 사업비: 5억원

주요 내용:
1. AI 기반 학습자 수준 진단
2. 개인별 맞춤 학습 경로 제시
3. 실시간 학습 피드백 제공
4. 학습 성과 분석 및 리포트
```

## 동작 방식

보고서 생성 서비스는 다음과 같은 과정으로 동작합니다:

![보고서 생성 흐름도](docs/report_flow.png)

1. **사용자 입력**: 사용자가 문서의 주제, 목적, 주요 내용 등을 간략하게 입력합니다.
2. **입력 분석**: 시스템이 입력을 분석하여 적합한 템플릿을 선택하고 필요한 정보를 추출합니다.
3. **정보 수집**:
   - **RAG 검색**: 기존 문서 데이터베이스에서 관련 정보를 검색합니다. ChromaDB를 활용하여 벡터 기반 의미 검색을 수행하고, 관련성 높은 정보를 추출합니다.
   - **웹 검색**: 최신 정보가 필요한 경우 Google, Naver, Daum 등의 검색 엔진을 통해 실시간 정보를 수집합니다. 시장 규모, 트렌드, 경쟁사 정보 등을 자동으로 찾아 분석합니다.
4. **콘텐츠 생성**: 각 섹션별로 AI를 활용하여 수집된 정보를 바탕으로 콘텐츠를 생성합니다.
5. **시각적 요소 생성**: 필요에 따라 차트, 표, 다이어그램 등을 자동으로 생성합니다.
6. **문서 조립**: 생성된 콘텐츠와 시각적 요소를 조합하여 완성된 문서를 만듭니다.
7. **출력**: 사용자가 원하는 형식(PDF, DOCX, HWPX 등)으로 최종 문서를 출력합니다.

## 시스템 아키텍처

![시스템 아키텍처](docs/architecture.png)

시스템은 다음과 같은 주요 컴포넌트로 구성됩니다:

1. **사용자 인터페이스(ReportManager.js)**: 사용자의 요청을 받아 처리하는 JavaScript 인터페이스입니다.
2. **Python 브릿지(PythonBridge.js)**: JavaScript와 Python 간의 통신을 담당합니다.
3. **보고서 생성기(BizPlanContentGenerator)**: 핵심 기능을 수행하는 Python 모듈입니다.
4. **템플릿 저장소**: 다양한 문서 템플릿을 JSON 형식으로 관리합니다.
5. **RAG 검색 엔진**:
   - ChromaDB를 활용한 벡터 데이터베이스를 구축하여 문서의 의미적 검색을 지원합니다.
   - 기존 문서, 보고서, 데이터를 벡터화하여 저장하고, 사용자 요청과 관련된 정보를 효율적으로 검색합니다.
   - 검색 결과는 관련성 점수와 함께 반환되어 가장 적합한 정보를 우선적으로 활용합니다.
6. **웹 검색 서비스**:
   - 여러 검색 엔진 API를 통합하여 최신 정보를 수집합니다.
   - 검색 결과를 자동으로 필터링하고 요약하여 보고서에 활용 가능한 형태로 가공합니다.
   - 시장 데이터, 경쟁사 정보, 트렌드 분석 등 실시간 정보가 필요한 영역에 활용됩니다.
7. **AI 서비스(OpenAI API)**: 콘텐츠 생성 및 정보 요약에 활용됩니다.
8. **문서 빌더**: 최종 문서를 다양한 형식(PDF, DOCX, HWPX)으로 생성합니다.

## 사용 방법

### CLI 명령어 사용

```bash
# 기본 사용법
airun --report --format pdf < 요청파일.txt

# 한글 문서(hwpx) 형식으로 출력
airun --report --format hwpx < 요청파일.txt
```

### JavaScript 인터페이스 사용 예시

```javascript
import ReportManager from './services/report/ReportManager.js';

// 보고서 관리자 초기화
const reportManager = new ReportManager();
await reportManager.initialize();

// 사업계획서 생성 요청
const result = await reportManager.generateBusinessPlan({
    executive_summary: "AI 기반 개인화 학습 플랫폼 개발 사업계획서를 작성해주세요...",
    format: "pdf"  // 출력 형식: pdf, docx, hwpx 등
});

console.log(`생성된 파일 경로: ${result.file_path}`);
```

### 직접 Python 스크립트 실행

```bash
python services/report/generate_bizplan.py '{"executive_summary": "AI 기반 개인화 학습 플랫폼 개발 사업계획서를 작성해주세요...", "format": "pdf"}'
```

## 템플릿 선택 및 사용자 정의

### 자동 템플릿 선택

시스템은 사용자 입력을 분석하여 가장 적합한 템플릿을 자동으로 선택합니다:

1. **헤더 기반 선택**: 입력 파일 상단에 `# template: 템플릿명` 형식으로 명시적 지정 가능
2. **키워드 기반 선택**: 입력 내용에 포함된 키워드를 분석하여 적합한 템플릿 자동 선택
3. **기본 템플릿**: 특정 템플릿이 식별되지 않을 경우 기본값으로 'bizplan' 템플릿 사용

### 사용자 정의 템플릿 지정

사용자는 다음과 같은 방법으로 템플릿을 직접 지정할 수 있습니다:

1. **입력 파일 헤더에 지정**:
   ```
   # template: khnp02
   # pagebreak: false
   
   사업명: 한울본부 사옥시설 유지보수관리프로그램 개발용역
   ...
   ```

2. **API 호출 시 지정**:
   ```javascript
   const result = await reportManager.generateBusinessPlan({
       executive_summary: "...",
       template: "khnp02",
       format: "pdf"
   });
   ```

### 사용자 프롬프트 추가

보고서 생성 시 특별한 지시사항이나 형식 요구사항을 추가할 수 있습니다:

1. **프롬프트 섹션 추가**:
   ```
   # template: khnp02
   
   # prompt:
   [중요] 다음 형식을 반드시 준수할 것:
   - 섹션 제목이나 헤더를 포함하지 말고 바로 본문부터 시작.
   - 모든 문장은 반드시 글머리 기호 가. 나. 다. 형식으로 시작해야 함
   - 모든 문장은 명사로 종료하고 줄바꿈할 것
   #
   
   사업명: 한울본부 사옥시설 유지보수관리프로그램 개발용역
   ...
   ```

2. **API 호출 시 프롬프트 추가**:
   ```javascript
   const result = await reportManager.generateBusinessPlan({
       executive_summary: "...",
       custom_prompt: "모든 섹션은 간결하게 작성하고 전문 용어를 최소화할 것",
       format: "pdf"
   });
   ```

## 지원되는 템플릿 유형

- **simple**: 간단한 보고서 템플릿
- **bizplan**: 상세한 사업계획서 템플릿
- **startup**: 스타트업 사업계획서 템플릿
- **proposal**: 제안서 템플릿
- **marketing**: 마케팅 계획서 템플릿
- **thesis**: 논문 템플릿
- **khnp**: 한국수력원자력 보고서 템플릿

## 기술 스택

- **백엔드**: Python, Cython(성능 최적화)
- **프론트엔드 인터페이스**: JavaScript/Node.js
- **AI 모델**: OpenAI API
- **문서 생성**: ReportLab(PDF), python-docx(DOCX), pyhwpx(한글 문서)
- **데이터 시각화**: Matplotlib, Graphviz, Mermaid
- **정보 검색**: ChromaDB(벡터 데이터베이스), RAG(Retrieval-Augmented Generation)
- **웹 검색**: 자체 구현 검색 모듈, 검색 엔진 API 통합
