"""
report package - 사업계획서 생성 모듈
"""

import os
import sys
import glob

def find_compiled_module(name):
    """컴파일된 모듈 파일을 찾습니다."""
    current_dir = os.path.dirname(__file__)
    if sys.platform == 'win32':
        pattern = f"{name}.cp*-win_amd64.pyd"
    else:
        pattern = f"{name}.cpython-*-{sys.platform}-gnu.so"
    
    matches = glob.glob(os.path.join(current_dir, pattern))
    if matches:
        # 가장 최신 버전 사용
        return os.path.basename(matches[-1])
    return None

# utils 모듈 임포트
from utils import *

# report_generator 모듈 임포트
from .report_generator import BizPlanContentGenerator

# 컴파일된 모듈 찾기
report_generator_module = find_compiled_module('report_generator')

if report_generator_module:
    # 컴파일된 모듈이 있는 경우
    import importlib.util
    spec = importlib.util.spec_from_file_location("report_generator", 
        os.path.join(os.path.dirname(__file__), report_generator_module))
    report_generator = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(report_generator)
    
    # BizPlanContentGenerator 클래스 가져오기
    BizPlanContentGenerator = report_generator.BizPlanContentGenerator
    
    # 인스턴스 생성 및 함수 노출
    _generator = BizPlanContentGenerator()
    generate_business_plan = _generator.create_business_plan
    
    def check_environment():
        """환경 설정 확인"""
        # 필요한 디렉토리 확인
        required_dirs = [
            os.path.expanduser('~/.airun'),
            os.path.expanduser('~/.airun/cache'),
            os.path.expanduser('~/.airun/logs'),
            os.path.expanduser('~/.airun/chromadb')
        ]
        
        for d in required_dirs:
            if not os.path.exists(d):
                os.makedirs(d, exist_ok=True)
        
        return True
else:
    # 컴파일된 모듈이 없는 경우 경고
    print("[WARNING] Compiled report_generator module not found")
    raise ImportError("Compiled report_generator module not found")

__all__ = [
    'BizPlanContentGenerator',
    'generate_business_plan',
    'check_environment'
] 