import apiClient, { ApiResponse } from './apiClient';

// 모니터링 데이터 인터페이스
export interface MonitoringData {
  totalCalls: number;
  activeRequests: number;
  avgResponseTime: number;
  successRate: number;
  endpointStats: Record<string, {
    calls: number;
    avgResponseTime: number;
    errors: number;
  }>;
  callsHeatmap: number[][];
  timeLabels: string[];
  responseTimes: number[];
  errorRates: number[];
  logs: {
    timestamp: string;
    endpoint: string;
    method: string;
    responseTime: number;
    status: number;
    success: boolean;
  }[];
}

// 큐 상태 인터페이스
export interface QueueStatus {
  chat: {
    waiting: number;
    active: number;
    completed: number;
    failed: number;
    delayed: number;
    paused: number;
  };
  report: {
    waiting: number;
    active: number;
    completed: number;
    failed: number;
    delayed: number;
    paused: number;
  };
  api: {
    waiting: number;
    active: number;
    completed: number;
    failed: number;
    delayed: number;
    paused: number;
  };
  status: 'healthy' | 'warning' | 'error';
  message: string;
  timestamp: string;
}

// 사용량 인터페이스
export interface UsageData {
  used: number;
  limit: number;
  plan: string;
  planDetails: {
    name: string;
    rateLimit: {
      max: number;
      windowMs: number;
    }
  };
  resetDate: string;
  lastUpdated: string;
}

// 사용자 활동 인터페이스
export interface UserActivity {
  id: number;
  userId: number;
  username: string;
  action: string;
  details: any;
  ip: string;
  userAgent: string;
  timestamp: string;
}

// 모니터링 서비스 클래스
class MonitoringService {
  // API 모니터링 데이터 조회
  async getMonitorData(): Promise<ApiResponse<MonitoringData>> {
    return apiClient.get('/monitor/data');
  }

  // 큐 상태 조회
  async getQueueStatus(): Promise<ApiResponse<QueueStatus>> {
    return apiClient.get('/queues/status');
  }

  // 사용량 조회
  async getUsage(): Promise<ApiResponse<UsageData>> {
    return apiClient.get('/usage');
  }

  // 사용량 초기화
  async resetUsage(): Promise<ApiResponse<UsageData>> {
    return apiClient.post('/usage/reset');
  }

  // 사용자 활동 조회
  async getUserActivities(): Promise<ApiResponse<UserActivity[]>> {
    return apiClient.get('/auth/activities');
  }

  // 서버 상태 확인
  async checkHealth(): Promise<ApiResponse<{ status: string; uptime: number; timestamp: string }>> {
    return apiClient.get('/health');
  }
}

// 모니터링 서비스 인스턴스 생성
const monitoringService = new MonitoringService();

export default monitoringService; 