const express = require('express');
const app = express();
app.use(express.json());

const complaints = {
  1: {
    id: 1,
    title: '아파트 쓰레기 무단투기 신고',
    content: '우리 아파트 1동 앞에 매일 쓰레기를 무단투기하는 사람이 있습니다. 분리수거도 제대로 하지 않아서 환경이 매우 더러워지고 있습니다. CCTV 확인해서 단속해주세요.',
    category: '환경/위생',
    location: '서울시 강남구 테헤란로 123 아파트',
    reporter_name: '김민수',
    reporter_phone: '010-1234-5678',
    reporter_email: 'minsu@email.com',
    created_at: '2025-01-15T09:30:00Z',
    updated_at: '2025-01-15T09:30:00Z',
    status: 'pending',
    priority: 'medium',
    assigned_to: null,
    estimated_completion: null,
    history: [
      { 
        timestamp: '2025-01-15T09:30:00Z', 
        action: 'created', 
        by: '김민수', 
        content: '민원이 접수되었습니다.' 
      }
    ]
  },
  2: {
    id: 2,
    title: '위층 소음 신고 (심야시간)',
    content: '아파트 위층에서 매일 밤 11시 이후에 심한 소음이 발생합니다. 아이들 뛰는 소리, 가구 끄는 소리 등으로 잠을 잘 수가 없습니다. 여러 번 직접 얘기했지만 개선되지 않아 신고합니다.',
    category: '소음/진동',
    location: '서울시 서초구 반포대로 456 아파트 15동 1205호',
    reporter_name: '이영희',
    reporter_phone: '010-2345-6789',
    reporter_email: 'younghee@email.com',
    created_at: '2025-01-14T22:15:00Z',
    updated_at: '2025-01-15T10:20:00Z',
    status: 'in_progress',
    priority: 'high',
    assigned_to: 'noise_control_team',
    estimated_completion: '2025-01-20T18:00:00Z',
    history: [
      { 
        timestamp: '2025-01-14T22:15:00Z', 
        action: 'created', 
        by: '이영희', 
        content: '민원이 접수되었습니다.' 
      },
      { 
        timestamp: '2025-01-15T10:20:00Z', 
        action: 'replied', 
        by: 'noise_control_team', 
        content: '소음측정기 설치 예정입니다. 3일간 측정 후 조치하겠습니다.' 
      },
      { 
        timestamp: '2025-01-15T10:21:00Z', 
        action: 'status_updated', 
        status: 'in_progress' 
      }
    ]
  },
  3: {
    id: 3,
    title: '동네 가로등 고장 수리 요청',
    content: '우리 동네 주요 도로의 가로등 5개가 고장나서 밤에 너무 어둡습니다. 특히 학교 앞 구간이라 학생들 안전이 걱정됩니다. 빠른 수리 부탁드립니다.',
    category: '도로/교통',
    location: '서울시 마포구 홍익로 789 일대',
    reporter_name: '박철수',
    reporter_phone: '010-3456-7890',
    reporter_email: 'chulsoo@email.com',
    created_at: '2025-01-13T16:45:00Z',
    updated_at: '2025-01-13T16:45:00Z',
    status: 'pending',
    priority: 'high',
    assigned_to: null,
    estimated_completion: null,
    history: [
      { 
        timestamp: '2025-01-13T16:45:00Z', 
        action: 'created', 
        by: '박철수', 
        content: '민원이 접수되었습니다.' 
      }
    ]
  },
  4: {
    id: 4,
    title: '도로 포트홀 긴급 수리 필요',
    content: '메인 도로에 큰 구멍(포트홀)이 여러 개 생겨서 차량 통행에 매우 위험합니다. 오토바이가 넘어질 뻔한 사고도 있었습니다. 긴급 수리가 필요합니다.',
    category: '도로/교통',
    location: '서울시 용산구 한강대로 321 구간',
    reporter_name: '최민정',
    reporter_phone: '010-4567-8901',
    reporter_email: 'minjung@email.com',
    created_at: '2025-01-12T08:20:00Z',
    updated_at: '2025-01-14T15:30:00Z',
    status: 'resolved',
    priority: 'urgent',
    assigned_to: 'road_maintenance_team',
    estimated_completion: '2025-01-14T18:00:00Z',
    history: [
      { 
        timestamp: '2025-01-12T08:20:00Z', 
        action: 'created', 
        by: '최민정', 
        content: '민원이 접수되었습니다.' 
      },
      { 
        timestamp: '2025-01-12T09:15:00Z', 
        action: 'replied', 
        by: 'road_maintenance_team', 
        content: '긴급 민원으로 분류하여 당일 현장 확인 예정입니다.' 
      },
      { 
        timestamp: '2025-01-12T14:30:00Z', 
        action: 'replied', 
        by: 'road_maintenance_team', 
        content: '현장 확인 완료. 내일 오전 수리 작업 시작합니다.' 
      },
      { 
        timestamp: '2025-01-14T15:30:00Z', 
        action: 'replied', 
        by: 'road_maintenance_team', 
        content: '포트홀 수리 작업이 완료되었습니다. 확인 부탁드립니다.' 
      },
      { 
        timestamp: '2025-01-14T15:31:00Z', 
        action: 'status_updated', 
        status: 'resolved' 
      }
    ]
  },
  5: {
    id: 5,
    title: '공원 벤치 파손 및 교체 요청',
    content: '동네 공원의 벤치 3개가 파손되어 이용할 수 없는 상태입니다. 특히 어르신들이 많이 이용하시는 곳인데 불편을 겪고 계십니다. 새 벤치로 교체해주세요.',
    category: '공원/녹지',
    location: '서울시 종로구 세종로 555 세종공원',
    reporter_name: '김영수',
    reporter_phone: '010-5678-9012',
    reporter_email: 'youngsoo@email.com',
    created_at: '2025-01-11T14:20:00Z',
    updated_at: '2025-01-13T11:45:00Z',
    status: 'in_progress',
    priority: 'medium',
    assigned_to: 'park_management_team',
    estimated_completion: '2025-01-25T17:00:00Z',
    history: [
      { 
        timestamp: '2025-01-11T14:20:00Z', 
        action: 'created', 
        by: '김영수', 
        content: '민원이 접수되었습니다.' 
      },
      { 
        timestamp: '2025-01-13T11:45:00Z', 
        action: 'replied', 
        by: 'park_management_team', 
        content: '예산 확보 후 2주 내에 새 벤치로 교체 예정입니다.' 
      },
      { 
        timestamp: '2025-01-13T11:46:00Z', 
        action: 'status_updated', 
        status: 'in_progress' 
      }
    ]
  },
  6: {
    id: 6,
    title: '불법 주차 단속 요청',
    content: '우리 아파트 앞 도로에 매일 같은 차량들이 불법 주차를 하고 있습니다. 소방차 진입로까지 막고 있어 매우 위험합니다. 지속적인 단속을 요청합니다.',
    category: '주차/교통',
    location: '서울시 강서구 화곡로 888 일대',
    reporter_name: '정수현',
    reporter_phone: '010-6789-0123',
    reporter_email: 'suhyun@email.com',
    created_at: '2025-01-10T07:30:00Z',
    updated_at: '2025-01-10T07:30:00Z',
    status: 'pending',
    priority: 'medium',
    assigned_to: null,
    estimated_completion: null,
    history: [
      { 
        timestamp: '2025-01-10T07:30:00Z', 
        action: 'created', 
        by: '정수현', 
        content: '민원이 접수되었습니다.' 
      }
    ]
  },
  7: {
    id: 7,
    title: '하수구 악취 및 막힘 신고',
    content: '우리 동네 하수구에서 심한 악취가 나고 있습니다. 비가 올 때마다 물이 역류해서 도로가 침수되기도 합니다. 하수구 청소 및 점검을 요청합니다.',
    category: '환경/위생',
    location: '서울시 동대문구 청량리로 999 일대',
    reporter_name: '한미영',
    reporter_phone: '010-7890-1234',
    reporter_email: 'miyoung@email.com',
    created_at: '2025-01-09T19:15:00Z',
    updated_at: '2025-01-12T14:20:00Z',
    status: 'in_progress',
    priority: 'high',
    assigned_to: 'sewage_management_team',
    estimated_completion: '2025-01-18T16:00:00Z',
    history: [
      { 
        timestamp: '2025-01-09T19:15:00Z', 
        action: 'created', 
        by: '한미영', 
        content: '민원이 접수되었습니다.' 
      },
      { 
        timestamp: '2025-01-12T14:20:00Z', 
        action: 'replied', 
        by: 'sewage_management_team', 
        content: '현장 조사 완료. 하수관 교체 작업이 필요합니다. 1주일 내 작업 시작 예정입니다.' 
      },
      { 
        timestamp: '2025-01-12T14:21:00Z', 
        action: 'status_updated', 
        status: 'in_progress' 
      }
    ]
  },
  8: {
    id: 8,
    title: '어린이 놀이터 안전시설 점검 요청',
    content: '어린이 놀이터의 그네 체인이 녹슬어서 위험해 보입니다. 미끄럼틀도 표면이 거칠어져서 아이들이 다칠 수 있을 것 같습니다. 안전 점검 및 수리를 요청합니다.',
    category: '공원/녹지',
    location: '서울시 성북구 성북로 111 성북어린이공원',
    reporter_name: '오지현',
    reporter_phone: '010-8901-2345',
    reporter_email: 'jihyun@email.com',
    created_at: '2025-01-08T15:40:00Z',
    updated_at: '2025-01-08T15:40:00Z',
    status: 'pending',
    priority: 'high',
    assigned_to: null,
    estimated_completion: null,
    history: [
      { 
        timestamp: '2025-01-08T15:40:00Z', 
        action: 'created', 
        by: '오지현', 
        content: '민원이 접수되었습니다.' 
      }
    ]
  }
};

app.get('/api/complaints', (req, res) => {
  let result = Object.values(complaints);
  
  // 날짜 기반 필터링
  if (req.query.date_from) {
    const dateFrom = new Date(req.query.date_from);
    result = result.filter(c => new Date(c.created_at) >= dateFrom);
  }
  
  if (req.query.date_to) {
    const dateTo = new Date(req.query.date_to);
    result = result.filter(c => new Date(c.created_at) <= dateTo);
  }
  
  // 카테고리 필터링
  if (req.query.category) {
    result = result.filter(c => c.category === req.query.category);
  }
  
  // 상태 필터링
  if (req.query.status) {
    result = result.filter(c => c.status === req.query.status);
  }
  
  // 우선순위 필터링
  if (req.query.priority) {
    result = result.filter(c => c.priority === req.query.priority);
  }
  
  // 위치 검색
  if (req.query.location) {
    const locationQuery = req.query.location.toLowerCase();
    result = result.filter(c => c.location.toLowerCase().includes(locationQuery));
  }
  
  // 키워드 검색 (제목 + 내용)
  if (req.query.keyword) {
    const keyword = req.query.keyword.toLowerCase();
    result = result.filter(c => 
      c.title.toLowerCase().includes(keyword) || 
      c.content.toLowerCase().includes(keyword)
    );
  }
  
  // 정렬 (기본: 최신순)
  const sortBy = req.query.sort_by || 'created_at';
  const sortOrder = req.query.sort_order || 'desc';
  
  result.sort((a, b) => {
    let aVal = a[sortBy];
    let bVal = b[sortBy];
    
    if (sortBy.includes('_at')) {
      aVal = new Date(aVal);
      bVal = new Date(bVal);
    }
    
    if (sortOrder === 'desc') {
      return bVal > aVal ? 1 : -1;
    } else {
      return aVal > bVal ? 1 : -1;
    }
  });
  
  res.json(result);
});

app.get('/api/complaints/:id', (req, res) => {
  const complaint = complaints[req.params.id];
  if (!complaint) return res.status(404).send('Not found');
  res.json(complaint);
});

app.post('/api/complaints/:id/reply', (req, res) => {
  const id = req.params.id;
  const complaint = complaints[id];
  if (!complaint) return res.status(404).send('Not found');
  complaint.history.push({ action: 'replied', by: req.body.officer_id });
  res.json({ result: 'success', reply_id: `reply_${id}` });
});

app.put('/api/complaints/:id/status', (req, res) => {
  const id = req.params.id;
  const complaint = complaints[id];
  if (!complaint) return res.status(404).send('Not found');
  complaint.status = req.body.status;
  complaint.history.push({ action: 'status_updated', status: req.body.status });
  res.json({ result: 'success' });
});

app.get('/api/complaints/:id/history', (req, res) => {
  const complaint = complaints[req.params.id];
  if (!complaint) return res.status(404).send('Not found');
  res.json(complaint.history);
});

app.listen(4000, () => {
  console.log('Mock server running at http://localhost:4000');
});
