import { NextRequest, NextResponse } from 'next/server';
import { getUserFromRequest } from '../utils';

export async function GET(req: NextRequest) {
  try {
    console.log('=== /api/auth/me 요청 시작 ===');
    
    // 토큰 확인
    const authHeader = req.headers.get('Authorization');
    console.log('Authorization 헤더:', authHeader ? '있음' : '없음');
    
    if (authHeader) {
      console.log('Authorization 헤더 내용:', authHeader.substring(0, 20) + '...');
    }
    
    const user = await getUserFromRequest(req);
    console.log('getUserFromRequest 결과:', user ? '사용자 정보 있음' : '사용자 정보 없음');
    
    if (!user) {
      console.log('인증 실패: 사용자 정보가 없음');
      return NextResponse.json(
        {
          success: false,
          error: {
            message: '인증되지 않은 사용자입니다.'
          }
        },
        { status: 401 }
      );
    }

    console.log('인증 성공:', { id: user.id, username: user.username });
    return NextResponse.json({
      success: true,
      data: user
    });
  } catch (error) {
    console.error('사용자 정보 조회 중 오류:', error);
    return NextResponse.json(
      {
        success: false,
        error: {
          message: '사용자 정보를 가져오는 중 오류가 발생했습니다.'
        }
      },
      { status: 500 }
    );
  }
} 