import { NextRequest, NextResponse } from 'next/server';
import fs from 'fs';
import path from 'path';

const RESULTS_FILE = path.join(process.cwd(), 'ollama_eval_judge_results.json');

export async function GET() {
  try {
    if (!fs.existsSync(RESULTS_FILE)) {
      return NextResponse.json({});
    }
    
    const data = fs.readFileSync(RESULTS_FILE, 'utf-8');
    const results = JSON.parse(data);
    
    return NextResponse.json(results);
  } catch (error) {
    console.error('평가 결과 조회 오류:', error);
    return NextResponse.json({}, { status: 500 });
  }
} 