import { NextRequest, NextResponse } from 'next/server';
import { getRagServerUrl } from '@/config/serverConfig';

export async function GET(request: NextRequest) {
  try {
    const ragServerUrl = getRagServerUrl();
    const response = await fetch(`${ragServerUrl}/rag/progress`);
    
    if (!response.ok) {
      return NextResponse.json(
        { error: 'RAG 서버에서 진행 상태를 가져올 수 없습니다' },
        { status: response.status }
      );
    }
    
    const data = await response.json();
    return NextResponse.json(data);
  } catch (error) {
    console.error('[RAG Progress API] 오류:', error);
    return NextResponse.json(
      { error: 'RAG 진행 상태 조회 중 오류가 발생했습니다' },
      { status: 500 }
    );
  }
}