import { NextRequest, NextResponse } from 'next/server';
import fs from 'fs';
import path from 'path';

// 파일 기반 저장소 경로
const JOBS_FILE_PATH = path.join(process.cwd(), 'temp', 'background-jobs.json');

// cleanup 엔드포인트 - background-jobs.json 파일 정리
export async function POST(request: NextRequest) {
  try {
    // background-jobs.json 파일 삭제
    if (fs.existsSync(JOBS_FILE_PATH)) {
      fs.unlinkSync(JOBS_FILE_PATH);
      console.log('background-jobs.json 파일이 삭제되었습니다.');
    }
    
    return NextResponse.json({ 
      status: 'success', 
      message: '백그라운드 작업 정보가 정리되었습니다.' 
    });
  } catch (error) {
    console.error('백그라운드 작업 정보 정리 실패:', error);
    return NextResponse.json(
      { 
        status: 'error', 
        message: '백그라운드 작업 정보 정리 중 오류가 발생했습니다.' 
      },
      { status: 500 }
    );
  }
}
