// Promise.withResolvers polyfill 먼저 로드
import '@/lib/promise-polyfill';

import './globals.css';
import type { Metadata } from 'next';
import { Inter } from 'next/font/google';
import { initSupportTicketsTable } from '@/app/api/db';
import Header from '@/components/Header';
import ThemeProvider from '@/components/ThemeProvider';
import { LanguageProvider } from '@/contexts/LanguageContext';

// Initialize the database table on server start
initSupportTicketsTable();

const inter = Inter({ subsets: ['latin'] });

export const metadata: Metadata = {
  title: 'AI 워크스페이스',
  description: 'AI 기반 통합 워크스페이스',
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="ko" suppressHydrationWarning>
      <body className={inter.className} suppressHydrationWarning>
        <ThemeProvider>
          <LanguageProvider>
            <div className="h-screen flex flex-col" style={{ backgroundColor: 'var(--body-bg)' }}>
              {/* 상단 네비게이션 */}
              <Header />
              
              {/* 메인 콘텐츠 영역 */}
              <main className="flex-1 overflow-auto min-h-0" style={{ backgroundColor: 'var(--body-bg)' }}>
                {children}
              </main>
              
            </div>
          </LanguageProvider>
        </ThemeProvider>
      </body>
    </html>
  );
}
