'use client';

import { useAuth } from '@/hooks/useAuth';
import ClientOnly from '@/components/ClientOnly';

export default function TermsPage() {
  const { isInitialized } = useAuth();

  if (!isInitialized) {
    return (
      <div className="flex items-center justify-center min-h-screen">
        <div className="text-center">
          <div 
            className="animate-spin rounded-full h-8 w-8 mx-auto mb-4"
            style={{ 
              border: '2px solid #e5e7eb', 
              borderBottomColor: '#ea580c' 
            }}
          ></div>
          <p className="text-gray-600 dark:text-gray-400">로딩 중...</p>
        </div>
      </div>
    );
  }

  return (
    <ClientOnly fallback={
      <div className="flex items-center justify-center min-h-screen">
        <div className="text-center">
          <div 
            className="animate-spin rounded-full h-8 w-8 mx-auto mb-4"
            style={{ 
              border: '2px solid #e5e7eb', 
              borderBottomColor: '#ea580c' 
            }}
          ></div>
          <p className="text-gray-600 dark:text-gray-400">로딩 중...</p>
        </div>
      </div>
    }>
      <div className="bg-white dark:bg-gray-900">
        <div className="max-w-4xl mx-auto px-4 py-8">
          <div className="bg-white dark:bg-gray-900 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-8">
            <h1 className="text-3xl font-bold text-gray-900 dark:text-white mb-8">
              AI 서비스 이용약관
            </h1>
            
            <div className="prose prose-gray dark:prose-invert max-w-none">
              <div className="mb-6 p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg border border-blue-200 dark:border-blue-700">
                <p className="text-sm text-blue-800 dark:text-blue-200 mb-2">
                  <strong>시행일자:</strong> 2025년 1월 1일
                </p>
                <p className="text-sm text-blue-800 dark:text-blue-200">
                  <strong>최종 업데이트:</strong> 2025년 1월 1일
                </p>
              </div>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제1조 (목적)</h2>
                <p className="text-gray-700 dark:text-gray-300 mb-4">
                  본 약관은 (주)인베슘(이하 "회사")이 제공하는 AI 서비스(이하 "서비스")의 이용과 관련하여 
                  회사와 이용자 간의 권리와 의무, 책임사항 및 기타 필요한 사항을 규정함을 목적으로 합니다.
                </p>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제2조 (정의)</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    <strong>1. "서비스"</strong>란 회사가 제공하는 AI 기반 대화형 인공지능 플랫폼 및 관련 서비스를 의미합니다.
                  </p>
                  <p className="text-gray-700 dark:text-gray-300">
                    <strong>2. "이용자"</strong>란 본 약관에 따라 회사가 제공하는 서비스를 받는 회원 및 비회원을 의미합니다.
                  </p>
                  <p className="text-gray-700 dark:text-gray-300">
                    <strong>3. "회원"</strong>이란 회사에 개인정보를 제공하여 회원등록을 한 자로서, 회사의 정보를 지속적으로 제공받으며 회사가 제공하는 서비스를 계속적으로 이용할 수 있는 자를 의미합니다.
                  </p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제3조 (약관의 효력 및 변경)</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    1. 본 약관은 서비스 화면에 게시하거나 기타의 방법으로 회원에게 공지함으로써 효력이 발생합니다.
                  </p>
                  <p className="text-gray-700 dark:text-gray-300">
                    2. 회사는 관련 법령에 위배되지 않는 범위에서 본 약관을 개정할 수 있습니다.
                  </p>
                  <p className="text-gray-700 dark:text-gray-300">
                    3. 약관이 변경되는 경우, 회사는 변경된 약관의 적용일자 및 변경사유를 명시하여 현행약관과 함께 적용일자 7일 이전부터 적용일자 전일까지 공지합니다.
                  </p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제4조 (회원가입)</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    1. 이용자는 회사가 정한 가입 양식에 따라 회원정보를 기입한 후 본 약관에 동의한다는 의사표시를 함으로서 회원가입을 신청합니다.
                  </p>
                  <p className="text-gray-700 dark:text-gray-300">
                    2. 회사는 제1항과 같이 회원으로 가입할 것을 신청한 이용자 중 다음 각 호에 해당하지 않는 한 회원으로 등록합니다.
                  </p>
                  <div className="ml-4 space-y-2">
                    <p className="text-gray-700 dark:text-gray-300">가. 등록 내용에 허위, 기재누락, 오기가 있는 경우</p>
                    <p className="text-gray-700 dark:text-gray-300">나. 기타 회원으로 등록하는 것이 회사의 기술상 현저히 지장이 있다고 판단되는 경우</p>
                  </div>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제5조 (서비스의 제공)</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    1. 회사는 회원에게 아래와 같은 서비스를 제공합니다.
                  </p>
                  <div className="ml-4 space-y-2">
                    <p className="text-gray-700 dark:text-gray-300">가. AI 기반 대화 서비스</p>
                    <p className="text-gray-700 dark:text-gray-300">나. 문서 분석 및 요약 서비스</p>
                    <p className="text-gray-700 dark:text-gray-300">다. 코드 생성 및 분석 서비스</p>
                    <p className="text-gray-700 dark:text-gray-300">라. 기타 회사가 정하는 서비스</p>
                  </div>
                  <p className="text-gray-700 dark:text-gray-300">
                    2. 회사는 운영상, 기술상의 필요에 따라 제공하고 있는 전부 또는 일부 서비스를 변경할 수 있습니다.
                  </p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제6조 (이용자의 의무)</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    이용자는 다음 행위를 하여서는 안 됩니다.
                  </p>
                  <div className="ml-4 space-y-2">
                    <p className="text-gray-700 dark:text-gray-300">1. 신청 또는 변경 시 허위 내용의 등록</p>
                    <p className="text-gray-700 dark:text-gray-300">2. 타인의 정보 도용</p>
                    <p className="text-gray-700 dark:text-gray-300">3. 회사가 게시한 정보의 변경</p>
                    <p className="text-gray-700 dark:text-gray-300">4. 회사가 정한 정보 이외의 정보(컴퓨터 프로그램 등) 등의 송신 또는 게시</p>
                    <p className="text-gray-700 dark:text-gray-300">5. 회사 기타 제3자의 저작권 등 지적재산권에 대한 침해</p>
                    <p className="text-gray-700 dark:text-gray-300">6. 회사 기타 제3자의 명예를 손상시키거나 업무를 방해하는 행위</p>
                    <p className="text-gray-700 dark:text-gray-300">7. 외설 또는 폭력적인 메시지, 화상, 음성, 기타 공서양속에 반하는 정보를 서비스에 공개 또는 게시하는 행위</p>
                  </div>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제7조 (저작권의 귀속 및 이용제한)</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    1. 회사가 작성한 저작물에 대한 저작권 기타 지적재산권은 회사에 귀속합니다.
                  </p>
                  <p className="text-gray-700 dark:text-gray-300">
                    2. 이용자는 서비스를 이용함으로써 얻은 정보 중 회사에게 지적재산권이 귀속된 정보를 회사의 사전 승낙 없이 복제, 송신, 출판, 배포, 방송 기타 방법에 의하여 영리목적으로 이용하거나 제3자에게 이용하게 하여서는 안됩니다.
                  </p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제8조 (손해배상)</h2>
                <p className="text-gray-700 dark:text-gray-300">
                  회사는 무료로 제공되는 서비스와 관련하여 회원에게 어떠한 손해가 발생하더라도 동 손해가 회사의 고의 또는 중대한 과실에 의한 경우를 제외하고 이에 대하여 책임을 부담하지 아니합니다.
                </p>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제9조 (분쟁해결)</h2>
                <div className="space-y-3">
                  <p className="text-gray-700 dark:text-gray-300">
                    1. 회사는 이용자가 제기하는 정당한 의견이나 불만을 반영하고 그 피해를 보상처리하기 위하여 피해보상처리기구를 설치·운영합니다.
                  </p>
                  <p className="text-gray-700 dark:text-gray-300">
                    2. 회사와 이용자 간에 발생한 전자상거래 분쟁에 관한 소송은 서울중앙지방법원을 관할 법원으로 합니다.
                  </p>
                </div>
              </section>

              <section className="mb-8">
                <h2 className="text-xl font-semibold text-gray-900 dark:text-white mb-4">제10조 (연락처)</h2>
                <div className="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg">
                  <div className="space-y-2">
                    <p className="text-gray-700 dark:text-gray-300">
                      <strong>회사명:</strong> (주)인베슘
                    </p>
                    <p className="text-gray-700 dark:text-gray-300">
                      <strong>담당자:</strong> 김형채
                    </p>
                    <p className="text-gray-700 dark:text-gray-300">
                      <strong>전화번호:</strong> 02-2039-3977
                    </p>
                    <p className="text-gray-700 dark:text-gray-300">
                      <strong>이메일:</strong> sales@invesume.com
                    </p>
                  </div>
                </div>
              </section>

              <div className="mt-12 pt-8 border-t border-gray-200 dark:border-gray-700">
                <p className="text-sm text-gray-500 dark:text-gray-400 text-center">
                  본 약관은 2025년 1월 1일부터 적용됩니다.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </ClientOnly>
  );
} 