import Link from 'next/link';

export default function Footer() {
  return (
    <footer className="border-t border-gray-200 dark:border-gray-700 px-4 pt-4 pb-2" style={{ backgroundColor: 'var(--background)' }}>
      <div className="flex items-center justify-center space-x-4 text-xs text-muted-foreground">
        <Link 
          href="/terms" 
          className="hover:text-foreground transition-colors"
        >
          이용약관
        </Link>
        <span>•</span>
        <Link 
          href="/privacy" 
          className="hover:text-foreground transition-colors"
        >
          개인정보처리방침
        </Link>
        <span>•</span>
        <Link 
          href="/support" 
          className="hover:text-foreground transition-colors"
        >
          고객센터
        </Link>
        <span>•</span>
        <span>© 2025 invesume.com</span>
      </div>
    </footer>
  );
}
