import React from 'react';

interface MarkdownProps {
  content: string;
}

export const Markdown: React.FC<MarkdownProps> = ({ content }) => {
  // 간단한 Markdown 구현
  // 실제로는 ReactMarkdown 같은 라이브러리를 사용하는 것이 좋습니다.
  const formatContent = (text: string) => {
    if (!text) return '';
    
    // 코드 블록 처리
    let formattedText = text.replace(/```([\s\S]*?)```/g, '<pre><code>$1</code></pre>');
    
    // 인라인 코드 처리
    formattedText = formattedText.replace(/`([^`]+)`/g, '<code>$1</code>');
    
    // 개행 처리
    formattedText = formattedText.replace(/\n/g, '<br />');
    
    return formattedText;
  };

  return (
    <div 
      className="prose dark:prose-invert max-w-none"
      dangerouslySetInnerHTML={{ __html: formatContent(content) }}
    />
  );
}; 