# AI.RUN (AIRUN)

AI.RUN은 다양한 AI 모델을 통합하고 조율하여 실제 시스템 작업을 수행할 수 있는 강력한 AI 에이전트 오케스트레이션 플랫폼입니다.

## 📋 목차

- [프로젝트 개요](#프로젝트-개요)
- [시스템 아키텍처](#시스템-아키텍처)
- [설치 및 설정](#설치-및-설정)
- [주요 기능](#주요-기능)
- [개발 환경](#개발-환경)
- [API 서버](#api-서버)
- [서비스 관리](#서비스-관리)
- [프로젝트 구조](#프로젝트-구조)
- [빌드 및 배포](#빌드-및-배포)
- [개발 가이드](#개발-가이드)
- [문제 해결](#문제-해결)

## 🚀 프로젝트 개요

- **제품명**: Hamonize
- **내부 코드명**: AIRUN
- **설명**: AI 기반 통합 문서 생성 및 관리 시스템
- **버전**: 5.5.2
- **라이선스**: Apache-2.0 OR Commercial

## 🏗️ 시스템 아키텍처

### 핵심 서비스 및 포트

| 서비스 | 포트 | 파일 경로 | 설명 |
|--------|------|-----------|------|
| **API Server** | 5500 | `api_server.js` | 메인 API 서버 (Express.js) |
| **RAG Server** | 5600 | `plugins/rag/airun-rag.py` | 문서 검색 및 임베딩 서비스 |
| **Web Search Server** | 5610 | `services/websearch/airun-websearch-server.py` | 웹 검색 서비스 |
| **Report Server** | 5620 | `services/report/airun-report-server.py` | 보고서 생성 서비스 |
| **Web Client** | 5700 | `workspaces/web/` | Next.js 웹 클라이언트 |

### 서비스 이름 (systemd)
- `airun-api` - API 서버
- `airun-rag` - RAG 서버  
- `airun-websearch` - 웹 검색 서버
- `airun-report` - 보고서 서버
- `airun-rq-worker` - 작업 큐 워커

## 💻 설치 및 설정

### 사전 요구사항

- **Node.js**: 22.18.0 이상
- **npm**: 10.0.0 이상
- **Python**: 3.12 이상
- **PostgreSQL**: 13 이상 (포트 5433)
- **Redis**: 6.0 이상 (포트 6379)

### 운영체제별 설치

```bash
# Windows (PowerShell)
.\install.ps1

# Linux/macOS
./install.sh
```

### 환경 변수 설정

`~/.airun/airun.conf` 파일에 설정:

```ini
# AI 프로바이더 API 키
export OPENAI_API_KEY="your_openai_key"
export ANTHROPIC_API_KEY="your_anthropic_key"
export GEMINI_API_KEY="your_gemini_key"
export GROQ_API_KEY="your_groq_key"

# 데이터베이스 설정
export DB_HOST="localhost"
export DB_PORT="5433"
export DB_USER="ivs"
export DB_PASSWORD="1234"
export DB_NAME="airun"

# Redis 설정
export REDIS_HOST="localhost"
export REDIS_PORT="6379"

# 서비스 URL
export RAG_SERVER_URL="http://localhost:5600"
export WEB_SEARCH_URL="http://localhost:5610"
export REPORT_SERVER_URL="http://localhost:5620"

# 기능 토글
export USE_RAG="true"
export USE_WEB_SEARCH="true"
export USE_REVIEW="true"
export AUTO_EXECUTE="false"
```

## 🌟 주요 기능

### 1. CLI/GUI 모드
```bash
# GUI 모드로 실행
airun -g

# CLI 모드로 실행
airun

# 설정 초기화
airun -r
```

### 2. AI 대화 모드 (--chat)
```bash
# 기본 대화
airun --chat "질문"

# RAG와 웹 검색을 활용한 대화
airun --chat --rag --web "질문"
```

### 3. 코드 생성 모드 (--code)
```bash
# 대화형 코드 생성
airun --code "코드 생성 요청"

# 코드를 원하는 언어 파일로 저장
airun -o result.py "웹 서버 만들기"
```

### 4. 자동화 에이전트 모드 (--agent)
```bash
# 직접 명령 실행
airun --agent "작업 요청"

# 스크립트 파일로 실행
airun --agent < scripts/job.txt
```

### 5. 보고서 생성 모드 (--report)
```bash
# 기본 PDF 형식
airun --report "보고서 주제"

# HWPX 형식으로 출력
airun --report --format hwpx "보고서 주제"

# 템플릿 사용
airun --report --template simple --format hwpx "보고서 주제"
```

## 🛠️ 개발 환경

### 기술 스택

#### 백엔드
- **Node.js**: Express.js 기반 API 서버
- **Python**: AI 모델 통합 및 플러그인
- **PostgreSQL**: 메인 데이터베이스
- **Redis**: 캐싱 및 작업 큐
- **Bull**: 작업 큐 관리

#### 프론트엔드
- **Next.js 15**: 웹 클라이언트 (포트 5700)
- **React 19**: UI 컴포넌트
- **Tailwind CSS**: 스타일링
- **TypeScript**: 타입 안전성

#### AI/ML
- **LangChain**: AI 체인 및 에이전트
- **ChromaDB**: 벡터 데이터베이스 (RAG)
- **Transformers.js**: 클라이언트 사이드 AI

### 개발 명령어

```bash
# 개발 모드 실행
npm run dev

# 웹 클라이언트 개발
cd workspaces/web
npm run dev

# 테스트 실행
npm run test

# 코드 린팅
npm run lint

# 보안 감사
npm run security:audit
```

## 🔌 API 서버

### 서버 관리
```bash
# 서버 시작
airun api-server-start

# 서버 상태 확인
airun api-server-status

# 서버 중지
airun api-server-stop
```

### API 접근
- **Swagger UI**: http://localhost:5500/api-docs
- **Base URL**: http://localhost:5500/api/v1

### 인증 방법

#### 1. JWT 토큰 인증 (웹 UI용)
```bash
# 로그인
curl -X POST http://localhost:5500/api/v1/auth/login \
  -H "Content-Type: application/json" \
  -d '{"username": "your_username", "password": "your_password"}'

# 토큰 사용
curl -H "Authorization: Bearer <jwt_token>" \
  http://localhost:5500/api/v1/sessions
```

#### 2. API 키 인증 (외부 통합용)
```bash
# API 키 사용
curl -H "X-API-Key: airun_<user_id>_<random_key>" \
  http://localhost:5500/api/v1/chat
```

### 주요 API 엔드포인트

```bash
# 헬스 체크
GET /api/v1/health

# 채팅/대화
POST /api/v1/chat
{
  "prompt": "Hello world",
  "userId": 1,
  "sessionId": "chat-123",
  "rag": false,
  "web": false
}

# 코드 생성
POST /api/v1/code
{
  "prompt": "Write Python code to calculate fibonacci",
  "userId": 1
}

# 보고서 생성
POST /api/v1/report
{
  "prompt": "Create a business plan for AI startup",
  "format": "pdf",
  "template": "simple",
  "userId": 1
}

# RAG 문서 관리
POST /api/v1/rag/add
# multipart/form-data: file, userId

# 웹 검색
POST /api/v1/web/search
{
  "query": "AI trends 2025",
  "userId": 1
}
```

## 🚦 서비스 관리

### systemd 서비스 관리

```bash
# 서비스 상태 확인
echo "exitem08" | sudo -S systemctl status airun-api
echo "exitem08" | sudo -S systemctl status airun-rag
echo "exitem08" | sudo -S systemctl status airun-websearch
echo "exitem08" | sudo -S systemctl status airun-report

# 서비스 재시작
echo "exitem08" | sudo -S systemctl restart airun-api

# 서비스 로그 확인
echo "exitem08" | sudo -S journalctl -u airun-api -n 50

# 부팅 시 자동 시작
echo "exitem08" | sudo -S systemctl enable airun-api
```

### 헬스 체크

```bash
# 모든 서비스 헬스 체크
for port in 5500 5600 5610 5620; do
  echo "Testing port $port:"
  curl -s http://localhost:$port/health || echo "Service on $port is down"
done
```

### 로그 위치

- **사용자 레벨 로그**: `~/.airun/logs/`
  - `airun-api.log`, `airun-api_error.log`
  - `airun-rag.log`
  - `airun-websearch.log`
  - `airun-report.log`

- **시스템 로그**: `/var/log/airun/` (systemd 서비스 사용 시)

## 📁 프로젝트 구조

```
airun/
├── 📁 services/                 # 핵심 서비스
│   ├── 📁 auth/                # 인증 및 권한 관리
│   ├── 📁 database/            # 데이터베이스 관리
│   ├── 📁 report/              # 보고서 생성 서비스
│   ├── 📁 websearch/           # 웹 검색 서비스
│   └── 📁 core/                # 공통 기능
├── 📁 plugins/                  # AI 플러그인
│   ├── 📁 rag/                 # RAG (Retrieval-Augmented Generation)
│   ├── 📁 websearch/           # 웹 검색 플러그인
│   ├── 📁 ocr/                 # OCR 플러그인
│   └── 📁 replicate/           # Replicate AI 플러그인
├── 📁 workspaces/               # 웹/모바일 클라이언트
│   ├── 📁 web/                 # Next.js 웹 클라이언트
│   └── 📁 shared/              # 공통 코드
├── 📁 langfuse/                 # Langfuse 통합
├── 📁 docker/                   # Docker 설정
├── 📁 docs/                     # 문서
├── 📁 tests/                    # 테스트
├── 📁 scripts/                  # 빌드 및 유틸리티 스크립트
├── 📁 assets/                   # 아이콘 및 리소스
├── 📁 lang/                     # 다국어 지원
├── 📁 prompts/                  # AI 프롬프트 템플릿
├── 📁 templates/                # 보고서 템플릿
├── 📁 cache/                    # 캐시 데이터
├── 📁 logs/                     # 로그 파일
├── 📁 uploads/                  # 업로드된 파일
├── 📁 output/                   # 생성된 출력물
├── 📁 models/                    # AI 모델 파일
├── 📁 lora/                     # LoRA 모델
├── 📁 license/                  # 라이선스 관리
├── 📁 queues/                   # 작업 큐 관리
├── 📁 tools/                    # 도구 및 유틸리티
├── 📁 utils/                    # 공통 유틸리티
├── 📁 types/                    # TypeScript 타입 정의
├── 📁 renderer/                 # Electron 렌더러
├── 📁 static/                   # 정적 파일
├── 📁 swagger/                  # API 문서
├── 📁 pages/                    # 웹 페이지
├── 📁 feedback/                 # 피드백 시스템
├── 📁 examples/                 # 예제 및 샘플
├── 📁 user-tools/               # 사용자 정의 도구
├── 📁 code_export/              # 코드 내보내기
├── 📁 build/                    # 빌드 출력
├── 📁 deploy/                   # 배포 파일
├── 📁 node_modules/             # Node.js 의존성
├── 📄 api_server.js             # 메인 API 서버
├── 📄 index.js                  # CLI/GUI 메인 진입점
├── 📄 mainLogic.js              # 핵심 비즈니스 로직
├── 📄 aiFeatures.js             # AI 기능 통합
├── 📄 configuration.js          # 설정 관리
├── 📄 package.json              # 프로젝트 메타데이터
├── 📄 setup.py                  # Python 빌드 설정
├── 📄 build.js                  # 빌드 스크립트
├── 📄 Dockerfile                # Docker 이미지 정의
├── 📄 docker-compose.yml        # Docker Compose 설정
├── 📄 .env.example              # 환경 변수 예제
├── 📄 README.md                 # 프로젝트 문서
└── 📄 LICENSE                   # 라이선스
```

## 🔨 빌드 및 배포

### 메인 빌드
```bash
npm run build          # 전체 빌드 (Python 컴파일 + MCP 서버 복사 + 난독화)
npm run build:clean    # 클린 빌드
npm run build:smart    # 스마트 빌드 (기존 .so 파일 보존)
```

### MCP 서버 빌드 (별도)
```bash
npm run build:mcp       # MCP 서버들만 빌드
npm run build:mcp:clean # MCP 서버 클린 빌드
npm run clean:mcp       # MCP 서버 빌드 파일 정리
```

### GUI 빌드
```bash
npm run build:gui      # 모든 플랫폼용 GUI 빌드
npm run build:linux    # Linux용 GUI 빌드
npm run build:mac      # macOS용 GUI 빌드
npm run build:win      # Windows용 GUI 빌드
```

### Python 모듈 빌드
```bash
npm run build:python:all    # 모든 Python 플러그인 빌드
npm run build:python:smart  # 스마트 Python 빌드
npm run build:python:plugins # 플러그인만 빌드
```

### Docker 빌드
```bash
# 배포 파일 생성
node build.js

# Docker 이미지 빌드
docker build -t airun:latest .

# Docker 실행
docker run -it --rm \
  -v $(pwd)/airun_data:/data/airun \
  -v $(pwd)/docs:/data/docs \
  airun:latest
```

## 👨‍💻 개발 가이드

### 코드 컨벤션

- **JavaScript/TypeScript**: ES6+ 모듈 시스템 사용
- **Python**: PEP 8 스타일 가이드 준수
- **API 응답**: 표준 응답 형식 사용
- **에러 처리**: 적절한 HTTP 상태 코드와 사용자 친화적 메시지

### 표준 API 응답 형식

```json
{
  "success": true,
  "data": {},
  "error": {
    "code": "ERROR_CODE",
    "message": "Human-friendly error message"
  },
  "timestamp": "2024-01-01T12:00:00.000Z"
}
```

### 에러 코드

- `INTERNAL_SERVER_ERROR`: 내부 서버 오류
- `NETWORK_ERROR`: 네트워크 오류
- `FORBIDDEN`: 권한 없음 (403)
- `NOT_FOUND`: 리소스 없음 (404)
- `METHOD_NOT_ALLOWED`: 허용되지 않은 메서드 (405)
- `INVALID_JSON`: 잘못된 JSON (400)

### 데이터베이스 연결

```bash
# 환경 변수 (개발/기본값)
DB_HOST=localhost          # PostgreSQL 호스트
DB_PORT=5433              # PostgreSQL 포트
DB_USER=ivs               # 데이터베이스 사용자
DB_PASSWORD=1234          # 데이터베이스 비밀번호
DB_NAME=airun             # 데이터베이스 이름

# Docker 배포 시 포트 5432 사용
```

### Redis 설정

```bash
REDIS_HOST=localhost       # Redis 호스트
REDIS_PORT=6379           # Redis 포트
REDIS_URL=redis://localhost:6379  # Redis URL
```

### 설정 파일 우선순위

1. **프로세스 환경 변수** (최우선)
2. **`.env` 파일** (dotenv로 로드)
3. **`~/.airun/airun.conf`**
4. **내장 기본값**

## 🐛 문제 해결

### 일반적인 문제

#### 1. 401 Unauthorized
- API 키 형식과 유효성 확인
- 사용자 상태 확인

#### 2. 403 Forbidden
- 사용자 권한 확인
- API 키 권한 확인

#### 3. 500 Internal Server Error
- `~/.airun/logs/`에서 서비스 로그 확인
- 데이터베이스 연결 상태 확인

#### 4. 서비스 사용 불가
- systemd 서비스 상태 확인
- 포트 사용 가능 여부 확인

### 디버깅 절차

1. **해당 로그 파일 확인**: `~/.airun/logs/`
2. **systemd 로그 확인**: `journalctl -u <service>`
3. **로그에서 근본 원인 파악**
4. **서비스 재시작 전 문제 해결**

### 로그 관리

- **최대 파일 크기**: 100MB
- **보관 기간**: 30일
- **메모리 로그 버퍼**: 최대 1000개 항목

## 📚 추가 리소스

- **개발자 문서**: [docs/developer-docs.md](docs/developer-docs.md)
- **설치 가이드**: [docs/installation-setup.md](docs/installation-setup.md)
- **사용자 가이드**: [docs/user-guide.md](docs/user-guide.md)
- **문제 해결**: [docs/troubleshooting.md](docs/troubleshooting.md)
- **제품 개요**: [docs/product-overview.md](docs/product-overview.md)

## 🤝 기여하기

프로젝트에 기여하기 전에 다음 사항을 확인해 주세요:

1. **코드 컨벤션** 준수
2. **변경 사항에 대한 테스트** 추가
3. **Pull Request 생성 전 코드 리뷰**

## 📞 기술 지원

- **이메일**: sales@invesume.com
- **홈페이지**: https://invesume.com
- **전화**: 02-2039-3977

## 📄 라이선스

이 프로젝트는 [LICENSE](LICENSE) 파일에 명시된 라이선스에 따라 배포됩니다.

---

**주의사항**: 
- MCP 서버 빌드는 별도로 관리됩니다
- 빌드된 파일들은 Git에 포함되어 CI/CD 안정성을 보장합니다
- GitHub Actions에서는 빌드된 파일을 복사만 하므로 빌드 속도가 향상됩니다
