import { checkPageAccess } from './auth.js';

export async function chatPage(chatMessages, translations, reqAPI, getText, showCustomDialog, makeEditor, cline, sessionDate, promptSession, history_, messages_, askforce, summary, first, contextWindowRatio) {
    // 사용자 인증 체크
    const hasAccess = await checkPageAccess(reqAPI, 'chat');
    if (!hasAccess) {
        return;
    }

    // 입력 컨테이너 표시
    const inputContainer = document.querySelector('.input-container');
    if (inputContainer) {
        inputContainer.style.display = 'flex';
    }

    // 채팅 메시지 영역 초기화
    chatMessages.innerHTML = '';
    chatMessages.style.padding = '10px';

    // createConversationLine 함수 임포트 (renderer.js에서 가져오기)
    const createConversationLine = window.createConversationLine;

    // 히스토리가 있는지 확인
    const hasHistory = history_ && Array.isArray(history_) && history_.length > 0;
    
    // 히스토리가 있으면 대화 내용 복원, 없으면 환영 메시지 표시
    if (hasHistory) {
        console.log(`📚 대화 히스토리 복원 중... (${history_.length}개 메시지)`);
        
        // user와 assistant 롤의 메시지만 필터링하여 화면에 표시
        const filteredHistory = history_.filter(message => 
            message && 
            message.role && 
            message.content && 
            (message.role === 'user' || message.role === 'assistant')
        );
        
        console.log(`📝 필터링된 히스토리: ${filteredHistory.length}개 메시지 (전체 ${history_.length}개 중)`);
        
        filteredHistory.forEach((message, index) => {
            if (message.role === 'user') {
                // 사용자 메시지는 코드 에디터로 표시
                if (typeof createConversationLine === 'function') {
                    createConversationLine({
                        text: message.content,
                        type: 1, // 사용자 메시지
                        parent: chatMessages,
                        askforce: null,
                        restore: true,
                        last: index === filteredHistory.length - 1
                    });
                } else {
                    // fallback: 간단한 메시지 표시
                    const messageElement = document.createElement('div');
                    messageElement.className = 'message mine';
                    messageElement.style.marginBottom = '10px';
                    messageElement.style.padding = '10px';
                    messageElement.style.borderRadius = '8px';
                    messageElement.style.backgroundColor = 'var(--bg-secondary)';
                    messageElement.style.whiteSpace = 'pre-wrap';
                    messageElement.textContent = message.content;
                    chatMessages.appendChild(messageElement);
                }
            } else if (message.role === 'assistant') {
                // AI 응답: 코드가 포함되어 있는지 확인
                const hasCodeBlock = message.content && (
                    message.content.includes('```') || 
                    message.content.includes('def ') ||
                    message.content.includes('import ') ||
                    message.content.includes('class ') ||
                    message.content.includes('function ') ||
                    message.content.includes('const ') ||
                    message.content.includes('let ') ||
                    message.content.includes('var ')
                );
                
                if (hasCodeBlock && typeof createConversationLine === 'function') {
                    // 코드가 포함된 메시지는 코드 에디터로 표시
                    createConversationLine({
                        text: message.content,
                        type: 4, // AI 응답 (코드 에디터)
                        parent: chatMessages,
                        askforce: null,
                        restore: true,
                        last: index === filteredHistory.length - 1
                    });
                } else {
                    // 일반 텍스트 응답은 일반 HTML로 표시
                    const messageElement = document.createElement('div');
                    messageElement.className = 'message other';
                    messageElement.style.marginBottom = '10px';
                    messageElement.style.padding = '15px';
                    messageElement.style.borderRadius = '8px';
                    messageElement.style.backgroundColor = 'var(--bg-primary)';
                    messageElement.style.border = '1px solid var(--border-color)';
                    messageElement.style.lineHeight = '1.6';
                    
                    // 마크다운 스타일 텍스트 처리
                    const formattedContent = message.content
                        .replace(/\*\*(.*?)\*\*/g, '<strong>$1</strong>') // **굵은글씨**
                        .replace(/\*(.*?)\*/g, '<em>$1</em>') // *기울임*
                        .replace(/`(.*?)`/g, '<code style="background-color: var(--bg-secondary); padding: 2px 4px; border-radius: 3px; font-family: monospace;">$1</code>') // `인라인 코드`
                        .replace(/\n/g, '<br>'); // 줄바꿈
                    
                    messageElement.innerHTML = formattedContent;
                    chatMessages.appendChild(messageElement);
                }
            }
        });
        
        console.log(`✅ 대화 히스토리 복원 완료 (${filteredHistory.length}개 메시지 표시, ${history_.length - filteredHistory.length}개 시스템 메시지 필터링됨)`);
    } else {
        // 히스토리가 없으면 환영 메시지와 설정 정보 표시
        if (translations && Object.keys(translations).length > 0) {
            const helpMessage = document.createElement('div');
            helpMessage.className = 'message other welcome';
            
            // 환영 메시지 컨테이너
            const welcomeContainer = document.createElement('div');
            welcomeContainer.style.marginBottom = '15px';
            const welcomeText = getText('welcome', 'message');
            welcomeContainer.textContent = welcomeText;
            helpMessage.appendChild(welcomeContainer);

            // 모드 정보 컨테이너
            const modeInfoContainer = document.createElement('div');
            modeInfoContainer.style.display = 'flex';
            modeInfoContainer.style.flexDirection = 'column';
            modeInfoContainer.style.gap = '15px';
            modeInfoContainer.style.marginTop = '15px';
            modeInfoContainer.style.padding = '15px';
            modeInfoContainer.style.backgroundColor = 'var(--bg-secondary)';
            modeInfoContainer.style.borderRadius = '8px';

            // 현재 모드 표시
            const currentModeContainer = document.createElement('div');
            currentModeContainer.style.display = 'flex';
            currentModeContainer.style.alignItems = 'center';
            currentModeContainer.style.gap = '10px';

            const modeLabel = document.createElement('div');
            modeLabel.style.fontSize = '1em';
            modeLabel.style.fontWeight = 'bold';
            modeLabel.style.color = 'var(--text-primary)';
            modeLabel.style.width = '60px';
            modeLabel.textContent = getText('mode', 'label') + ':';

            const currentMode = document.createElement('div');
            currentMode.style.fontSize = '1em';
            currentMode.style.padding = '5px 15px';
            currentMode.style.borderRadius = '15px';
            currentMode.style.backgroundColor = 'var(--accent-color)';
            currentMode.style.color = 'var(--bg-primary)';
            
            // 현재 모드 확인
            const aiMode = await reqAPI('getconfig', { key: 'AIMODE' });
            currentMode.textContent = aiMode?.toLowerCase() === 'chat' ? getText('mode', 'chat') : getText('mode', 'execution');

            currentModeContainer.appendChild(modeLabel);
            currentModeContainer.appendChild(currentMode);

            // 옵션 컨테이너
            const optionsContainer = document.createElement('div');
            optionsContainer.style.display = 'flex';
            optionsContainer.style.alignItems = 'center';
            optionsContainer.style.gap = '10px';

            const optionsLabel = document.createElement('div');
            optionsLabel.style.fontSize = '1em';
            optionsLabel.style.fontWeight = 'bold';
            optionsLabel.style.color = 'var(--text-primary)';
            optionsLabel.style.width = '60px';
            optionsLabel.textContent = getText('options', 'label') + ':';

            // 모드 버튼 생성 함수
            const createOptionButton = (labelKey, value) => {
                const button = document.createElement('div');
                button.style.padding = '5px 15px';
                button.style.borderRadius = '15px';
                button.style.fontSize = '0.9em';
                button.style.backgroundColor = value?.toLowerCase() === 'yes' ? 'var(--accent-color)' : 'var(--border-color)';
                button.style.color = value?.toLowerCase() === 'yes' ? 'var(--bg-primary)' : 'var(--text-secondary)';
                button.textContent = getText('options', labelKey);
                return button;
            };

            // AI 모드 정보 가져오기
            const ragMode = await reqAPI('getconfig', { key: 'USE_RAG' });
            const webSearchMode = await reqAPI('getconfig', { key: 'USE_WEB_SEARCH' });
            const autoExecuteMode = await reqAPI('getconfig', { key: 'AUTO_EXECUTE' });
            const reviewMode = await reqAPI('getconfig', { key: 'USE_REVIEW' });

            // 옵션 버튼들을 담을 컨테이너
            const buttonsContainer = document.createElement('div');
            buttonsContainer.style.display = 'flex';
            buttonsContainer.style.gap = '8px';

            // 옵션 버튼 추가
            buttonsContainer.appendChild(createOptionButton('review', reviewMode));
            buttonsContainer.appendChild(createOptionButton('autoExecute', autoExecuteMode));
            buttonsContainer.appendChild(createOptionButton('rag', ragMode));
            buttonsContainer.appendChild(createOptionButton('webSearch', webSearchMode));

            optionsContainer.appendChild(optionsLabel);
            optionsContainer.appendChild(buttonsContainer);

            modeInfoContainer.appendChild(currentModeContainer);
            modeInfoContainer.appendChild(optionsContainer);
            helpMessage.appendChild(modeInfoContainer);
            chatMessages.appendChild(helpMessage);
        }
    }

    // 이전 대화 내용이 있다면 복원
    if (cline && cline.length > 0) {
        cline.forEach(line => {
            chatMessages.appendChild(line);
        });
    }
} 