import dbManager from '../database/index.js';

class ActivityLogger {
    async logActivity(userId, action, details = {}, ipAddress = null, userAgent = null) {
        try {
            await dbManager.query(
                `INSERT INTO activity_logs (
                    user_id,
                    action,
                    details,
                    ip_address,
                    user_agent
                ) VALUES ($1, $2, $3, $4, $5)`,
                [userId, action, details, ipAddress, userAgent]
            );
        } catch (error) {
            console.error('활동 로그 기록 중 오류:', error);
            // 로그 기록 실패는 전체 작업을 실패시키지 않도록 함
        }
    }

    static async log(action, details = {}, userId = null, ipAddress = null, userAgent = null) {
        try {
            await dbManager.query(
                `INSERT INTO activity_logs (
                    user_id,
                    action,
                    details,
                    ip_address,
                    user_agent
                ) VALUES ($1, $2, $3, $4, $5)`,
                [userId, action, details, ipAddress, userAgent]
            );
        } catch (error) {
            console.error('활동 로그 기록 중 오류:', error);
            // 로그 기록 실패는 전체 작업을 실패시키지 않도록 함
        }
    }

    async getRecentActivities(userId, limit = 100) {
        try {
            const result = await dbManager.query(`
                SELECT * FROM activity_logs
                WHERE user_id = $1
                ORDER BY created_at DESC
                LIMIT $2
            `, [userId, limit]);

            return result.rows;
        } catch (error) {
            console.error('활동 로그 조회 중 오류:', error);
            throw error;
        }
    }

    async getActivityStats(userId) {
        try {
            const result = await dbManager.query(`
                SELECT 
                    action,
                    COUNT(*) as count,
                    MAX(created_at) as last_activity
                FROM activity_logs
                WHERE user_id = $1
                GROUP BY action
                ORDER BY count DESC
            `, [userId]);

            return result.rows;
        } catch (error) {
            console.error('활동 통계 조회 중 오류:', error);
            throw error;
        }
    }

    async clearOldLogs(days = 30) {
        try {
            const result = await dbManager.query(`
                DELETE FROM activity_logs
                WHERE created_at < NOW() - INTERVAL '${days} days'
                RETURNING COUNT(*) as deleted_count
            `);

            return result.rows[0].deleted_count;
        } catch (error) {
            console.error('오래된 로그 삭제 중 오류:', error);
            throw error;
        }
    }
}

export default ActivityLogger;
