export function standardResponse(res, data = null, error = null) {
    const response = {
        success: !error,
        data: data,
        error: error ? { message: error.message } : null,
        timestamp: new Date().toISOString()
    };
    
    const status = error ? (error.status || 400) : 200;
    res.status(status).json(response);
} 