
### Minimal Flat 컴포넌트 스타일

## 컴포넌트 디자인
- **테두리**: border 1px solid #e2e8f0
- **배경**: transparent
- **그림자**: none
- **호버**: background #f8fafc
- **트랜지션**: background 0.2s ease
- **특징**: 깔끔하고 심플한 느낌

### 관리자 패널 레이아웃

## 레이아웃 구조
- **네비게이션**: 좌측 계층형 메뉴
- **대시보드**: 위젯 기반 그리드
- **데이터 테이블**: 페이지네이션
- **모달**: 편집/추가 폼
- **권한**: 역할 기반 접근

### Scale Transform 인터랙션

## 애니메이션 효과
- **트랜지션**: transform: scale()
- **지속시간**: 0.15s ease-out
- **적용 요소**: 버튼 클릭, 호버 효과
- **성능**: transform만 사용으로 최적화
- **접근성**: 시각적 피드백 제공

### Modern Sans 폰트 시스템

## 타이포그래피
- **영문**: Inter (300-700)
- **한글**: Pretendard (300-700)
- **폴백**: system-ui, sans-serif
- **크기**: 16px 기준, 1.25 배율
- **행간**: 1.5-1.6
- **특징**: 가독성 우선, 모던한 느낌

### Bootstrap Style 그리드 시스템

## 그리드 구조
- **컬럼**: 12컬럼 (Bootstrap 호환)
- **간격**: 30px (1.875rem)
- **브레이크포인트**: sm(576px), md(768px), lg(992px), xl(1200px)
- **컨테이너**: max-width 1140px
- **특징**: 표준화된 빠른 개발

### Rounded Soft 컴포넌트 스타일

## 컴포넌트 디자인
- **모서리**: border-radius 12px
- **그림자**: box-shadow 0 4px 6px rgba(0,0,0,0.1)
- **호버**: transform scale(1.02)
- **트랜지션**: all 0.2s ease
- **특징**: 친근하고 현대적인 느낌

### Standard 성능 최적화

## 성능 최적화 전략
- **이미지**: WebP 포맷 사용
- **폰트**: Google Fonts 최적화
- **CSS**: 파일 압축 및 최소화
- **JS**: 번들링 및 최소화
- **캐싱**: 브라우저 캐싱 활용

### Desktop First 반응형 전략

## 반응형 접근법
- **우선순위**: 데스크톱 우선 설계
- **브레이크포인트**: max-width 기준
- **그리드**: 다중 컬럼 → 단일 컬럼
- **네비게이션**: 전체 메뉴 → 햄버거 메뉴
- **이미지**: 큰 크기 → 작은 크기
- **특징**: 데스크톱 기능 중심

### Dual Theme 색상 시스템

## 라이트모드/다크모드 색상 팔레트

### 기본 색상 (Primary Colors)
**라이트모드:**
- **배경**: #ffffff (순백)
- **텍스트**: #0f172a (진한 회색)
- **카드**: #ffffff (순백)
- **테두리**: #e2e8f0 (연한 회색)

**다크모드:**
- **배경**: #0f172a (진한 청회색)
- **텍스트**: #f8fafc (밝은 회색)
- **카드**: #1e293b (중간 청회색)
- **테두리**: #334155 (중간 회색)

### 액센트 색상 (Accent Colors)
**기능별 색상 매핑:**
- **대화하기**: blue(#3b82f6) → purple(#8b5cf6)
- **문서**: green(#10b981) → teal(#14b8a6)
- **지원**: orange(#f97316) → red(#ef4444)
- **관리자**: indigo(#6366f1) → purple(#a855f7)

### 상태 색상 (Status Colors)
- **성공**: green-500 (라이트) / green-400 (다크)
- **경고**: yellow-500 (라이트) / yellow-400 (다크)
- **오류**: red-500 (라이트) / red-400 (다크)
- **정보**: blue-500 (라이트) / blue-400 (다크)

### CSS 변수 구조
```css
:root {
  --background: #ffffff;
  --foreground: #0f172a;
  --card-bg: #ffffff;
  --card-border: #e2e8f0;
  --text-primary: #0f172a;
  --text-secondary: #475569;
  --text-muted: #64748b;
}

.dark {
  --background: #0f172a;
  --foreground: #f8fafc;
  --card-bg: #1e293b;
  --card-border: #334155;
  --text-primary: #f8fafc;
  --text-secondary: #cbd5e1;
  --text-muted: #94a3b8;
}
```

### Tailwind 클래스 패턴

## 컴포넌트별 일관된 클래스 사용

### 카드형 컴포넌트
```jsx
className="rounded-2xl bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 shadow-xl hover:shadow-2xl transition-all duration-300"
```

### 텍스트 스타일
```jsx
// 제목
className="text-2xl font-bold text-gray-900 dark:text-white"
// 본문
className="text-gray-700 dark:text-gray-200"
// 보조 텍스트
className="text-gray-600 dark:text-gray-300"
```

### 버튼 스타일
```jsx
// 기본 버튼
className="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg transition-colors"
// 보조 버튼
className="bg-transparent border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700"
```

### 그라데이션 패턴
```jsx
// 배경 그라데이션
className="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 dark:from-gray-900 dark:via-slate-900 dark:to-indigo-950"
// 카드 그라데이션
className="bg-gradient-to-br from-blue-50 to-purple-50 dark:from-blue-900/20 dark:to-purple-900/20"
```

### Standard 성능 최적화

## 성능 최적화 전략
- **이미지**: WebP 포맷 사용
- **폰트**: Google Fonts 최적화
- **CSS**: 파일 압축 및 최소화
- **JS**: 번들링 및 최소화
- **캐싱**: 브라우저 캐싱 활용