import ApiKeyService from './ApiKeyService.js';

const apiKeyService = new ApiKeyService();

export const apiKeyMiddleware = async (req, res, next) => {
    try {
        const apiKey = req.headers['x-api-key'];
        if (!apiKey) {
            return res.status(401).json({
                success: false,
                error: {
                    message: 'API 키가 필요합니다.'
                }
            });
        }

        // API 키 검증 및 사용자 정보 가져오기
        const apiKeyInfo = await apiKeyService.verifyApiKey(apiKey, req.ip);
        
        // 요청 객체에 사용자 정보 추가
        req.user = {
            id: apiKeyInfo.userId,
            role: apiKeyInfo.userRole,
            permissions: apiKeyInfo.permissions,
            rateLimit: apiKeyInfo.rateLimit
        };

        // 컨텍스트 API 호환성을 위해 apiKeyInfo도 추가
        req.apiKeyInfo = {
            userId: apiKeyInfo.userId,
            userRole: apiKeyInfo.userRole,
            permissions: apiKeyInfo.permissions
        };

        next();
    } catch (error) {
        res.status(401).json({
            success: false,
            error: {
                message: error.message || 'API 키 인증에 실패했습니다.'
            }
        });
    }
}; 