import { NextRequest, NextResponse } from 'next/server';

const LLM_FINETUNE_BASE_URL = process.env.NEXT_PUBLIC_LLM_FINETUNE_API_SERVER || 'http://localhost:5630';

export async function GET(request: NextRequest) {
  try {
    const response = await fetch(`${LLM_FINETUNE_BASE_URL}/playground/sessions`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    });

    const data = await response.json();
    return NextResponse.json(data);
  } catch (error) {
    console.error('Sessions fetch error:', error);
    return NextResponse.json(
      { success: false, sessions: [], error: 'Failed to fetch sessions' },
      { status: 500 }
    );
  }
}

export async function POST(request: NextRequest) {
  try {
    const body = await request.json();
    
    const response = await fetch(`${LLM_FINETUNE_BASE_URL}/playground/sessions`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(body),
    });

    const data = await response.json();
    return NextResponse.json(data);
  } catch (error) {
    console.error('Session save error:', error);
    return NextResponse.json(
      { success: false, error: 'Failed to save session' },
      { status: 500 }
    );
  }
}