"use client";
import { PdfLoader, PdfHighlighter, Tip, Highlight } from "react-pdf-highlighter";
import React from "react";

interface PdfHighlightViewerProps {
  filePath: string;
}

export default function PdfHighlightViewer({ filePath }: PdfHighlightViewerProps) {
  return (
    <div style={{ position: 'absolute', inset: 0, width: '100%', height: '100%', minHeight: 600 }}>
      <PdfLoader url={filePath} beforeLoad={<div>로딩 중...</div>}>
        {(pdfDocument) => (
          <PdfHighlighter
            pdfDocument={pdfDocument}
            highlights={[
              {
                id: 'dummy',
                position: {
                  boundingRect: { x: 0, y: 0, width: 1, height: 1 } as any,
                  rects: [{ x: 0, y: 0, width: 1, height: 1 } as any],
                  pageNumber: 1
                },
                comment: { text: '', emoji: '' },
                content: { text: '' }
              }
            ]}
            onSelectionFinished={(position, content, hideTipAndSelection, transformSelection) =>
              <Tip
                onOpen={() => {
                  hideTipAndSelection();
                }}
                onConfirm={() => {}}
              />
            }
            highlightTransform={(highlight, index, setTip, hideTip, viewportToScaled, screenshot, isScrolledTo) => (
              <Highlight
                key={index}
                isScrolledTo={isScrolledTo}
                position={highlight.position}
                comment={highlight.comment}
              />
            )}
            scrollRef={() => {}}
            onScrollChange={() => {}}
            enableAreaSelection={() => true}
          />
        )}
      </PdfLoader>
    </div>
  );
}

interface SimplePdfViewerProps {
  filePath: string;
}

export function SimplePdfViewer({ filePath }: SimplePdfViewerProps) {
  return (
    <div className="w-full max-w-full flex-1 flex flex-col relative min-h-[600px] h-full">
      <iframe
        src={filePath}
        style={{ width: '100%', height: '100%', minHeight: 600, border: 'none' }}
        title="PDF 미리보기"
      />
    </div>
  );
} 