# AI.RUN 도움말

## 🌟 소개
AI.RUN은 강력한 AI 에이전트 오케스트레이션 도구로, 다양한 AI 모델을 통합하고 조율하여 실제 시스템 작업을 수행할 수 있는 혁신적인 솔루션입니다.

## 📱 사용 방법


### 환경설정
시스템 전반의 설정을 관리합니다.
- **AI 모델 설정**
  - AI 제공업체 선택 (OpenAI, Anthropic, Ollama, Gemini, Groq)
  - API 키 등록 및 관리
  - 모델 선택 및 설정
- **대화 설정**
  - 명령어 실행 전 검토 여부
  - 자동 실행 설정
  - 테마 설정 (다크/라이트)
  - 언어 설정 (한국어, 영어, 일본어, 중국어, 스페인어, 프랑스어)
- **RAG 설정**
  - RAG 기능 사용 여부
  - 문서 경로 설정
  - 데이터베이스 초기화 및 문서 처리
- **SMTP 설정**
  - 메일 서버 호스트
  - 포트 번호
  - 사용자 계정
  - 보안 연결 설정

### 대화
AI와 대화하고 작업을 요청할 수 있는 메인 화면입니다.
- **기본 사용법**
  - 대화창에 원하는 질문이나 작업을 입력
  - 우측 상단에서 사용할 AI 모델 선택
  - 전송 버튼을 눌러 대화 시작

### 작업목록
자주 사용하는 AI 작업을 저장하고 관리하는 화면입니다.
- **작업 등록 방법**
  1. 직접 등록
     - '새 작업' 버튼으로 새 작업 생성
     - 작업 이름과 설명 작성
     - AI에게 지시할 내용 미리 작성
  2. 대화창에서 등록
     - 대화창에서 성공한 작업의 '작업 등록' 버튼 클릭
     - 작업 이름과 설명 추가
     - 실행된 작업 내용이 자동으로 저장됨
- **캐시 작업**
  - 대화창에서 실행 성공한 작업을 등록하면 자동으로 캐시 작업 생성
  - AI 호출 없이 저장된 코드가 바로 실행되어 빠른 응답
  - 작업 실행 비용 절감 효과

### 문서 작성
다양한 템플릿으로 문서를 자동 생성하는 화면입니다.
  - 프롬프트를 입력하면 자동으로 PDF, HWP, DOC, PPT 형식의 문서를 생성할 수 있습니다
  - 템플릿에 따라 여러가지 유형의 문서를 자동으로 생성합니다.

### 사용통계
AI 모델 사용량과 비용을 확인하는 화면입니다.
- **전체 요약**
  - 총 비용과 총 토큰 사용량
  - 이번 달 비용과 토큰 사용량
  - 추세 분석 및 비교
- **제공자별 분석**
  - AI 제공자별 비용 및 토큰 사용량
  - 요청 수 통계
  - 제공자별 비용 분포 차트
- **상세 내역**
  - AI 호출 상세 내역 테이블
  - 시간, 제공자, 모델, 토큰, 비용 정보
  - CSV 형식 다운로드 지원

### 실행이력
AI와의 대화 중 실행된 모든 명령어와 결과를 확인하는 화면입니다.
- **실행 기록**
  - 실행 시간과 상태(성공/실패) 표시
  - 사용자 질의 내용
  - 실행된 코드
  - 실행 결과

## 🚀 주요 기능

### 1. AI 에이전트 오케스트레이션
- **멀티 프로바이더 통합**
  - OpenAI, Anthropic, Ollama, Google, Groq 등 다양한 AI 모델 활용
  - 로컬 실행(Ollama)과 클라우드 서비스를 유연하게 선택
  - 프로바이더 장애 시 자동 페일오버 지원
  - 비용/성능 최적화 기반 프로바이더 선택
  - **지능형 프로바이더 자동 선택**
    * 작업별 성능 점수 계산
    * 기본 모델 대체 메커니즘
    * 작업 유형별 가중치 적용
    * 자동 성능 최적화
  - **프로바이더 간 문맥 공유**
    * 프로바이더 간 원활한 문맥 전달
    * 지능형 문맥 압축 및 최적화
    * 자동 문맥 윈도우 관리
    * 세션 기반 문맥 유지
    * 프로바이더별 문맥 적응

### 2. 문서 처리 및 지식 관리
- **RAG (Retrieval-Augmented Generation)**
  - nlpai-lab/KURE-v1 모델 기반 고성능 임베딩(1024 차원의 임베딩 벡터, CUDA GPU 가속)
  - PostgreSQL + pgvector 조합의 안정적인 벡터 데이터 관리
  - 하이브리드 검색: 의미+키워드 결합 검색
  - 동적 문서 청크 분할 및 메타데이터 관리
- **다양한 문서 포맷 지원**
  - HWP, PDF, MS Office 문서 원본 처리
  - 표/이미지 추출 및 처리
  - 자동 메타데이터 추출 및 태깅
  - 대용량 문서 일괄 처리

### 3. 시스템 통합 및 자동화
- **작업 관리 시스템**
  - 반복 작업 자동화 및 스케줄링
  - 작업 실행 결과 추적
  - 실시간 모니터링 및 알림
  - 작업 이력 관리 및 재사용
- **시스템 통합**
  - 파일 시스템 직접 접근 및 조작
  - 시스템 명령어 실행 및 자동화
  - 로컬 프로그램 제어
  - 개발 환경 자동 구성

### 4. 웹 및 이메일 통합
- **통합 웹 검색**
  - Google, Naver, Daum 등 다국어 검색 엔진 통합
  - Selenium 기반 안정적 검색
  - 검색 결과 자동 분석 및 추출
  - 캐시 시스템으로 응답 속도 최적화
- **이메일 기능**
  - HTML 템플릿 지원
  - 대량 메일 발송
  - 첨부 파일 처리
  - 이메일 자동 응답 및 분류

### 5. 개발자 도구
- **코드 관리**
  - AST 기반 코드 분석
  - 코드 생성 및 최적화
  - 멀티런타임 지원 (Node.js, Python)
  - 샌드박스 실행 환경
- **패키지 관리**
  - 의존성 자동 해결
  - 버전 호환성 검사
  - 보안 취약점 검사
  - 가상환경 관리

## 💡 주요 장점

### 1. 비용 최적화
- **캐싱 시스템**
  - RAG 검색 결과 캐싱 (TTL: 72시간)
  - 웹 검색 결과 캐싱
  - 임베딩 결과 캐싱
  - 컬렉션 정보 캐싱
- **리소스 사용 최적화**
  - 토큰 사용량 모니터링
  - 비용 효율적인 모델 자동 선택
  - 배치 처리 최적화
  - 중복 요청 방지

### 2. 성능 및 안정성
- **고성능 아키텍처**
  - Node.js와 Python 하이브리드 구조
  - 프로세스 격리를 통한 안정성
  - 멀티스레드 처리
  - 메모리 사용 최적화
- **오류 처리 및 복구**
  - 자동 재시도 메커니즘
  - 장애 복구 시스템
  - 상세 에러 로깅
  - 자동 백업 및 복구

### 3. 보안 및 규정 준수
- **데이터 보안**
  - 로컬 환경 실행으로 데이터 유출 방지
  - 민감 정보 자동 검출 및 마스킹
  - 접근 제어 및 권한 관리
  - ISMS-P, GDPR 등 규정 준수
- **모니터링 및 감사**
  - 작업 실행 로그 기록
  - 리소스 사용량 모니터링
  - 보안 감사 리포트
  - 실시간 알림 시스템


## 📞 기술 지원
- 이메일: sales@invesume.com
- 홈페이지: https://invesume.com
- 전화: 02-2039-3977 / 010-3838-8378


