#compdef airun

_airun() {
    local curcontext="$curcontext" state line
    typeset -A opt_args

    local -a commands
    commands=(
        'auto:Toggle auto execution mode'
        'auto-analyze:Toggle auto code analysis and improvement feature'
        'auto-provider:Toggle auto provider selection feature'
        'web:Toggle web search feature'
        'rag:Toggle RAG feature'
        'rag-init:Initialize RAG'
        'rag-init-local:Initialize RAG locally'
        'rag-init-force:Force reinitialize RAG with all documents'
        'rag-queue-status:Check RAG document processing queue status'
        'rag-path:Set RAG documents path'
        'rag-precache:Create RAG cache'
        'rag-add:Add documents to RAG'
        'rag-remove:Remove document from RAG'
        'rag-search:Search in RAG documents'
        'web-search:Search the web for information'
        'task:Execute AI task'
        'set:Set configuration value'
        'update:Check for updates'
        'clear-cache:Clear cached data including web search and RAG search results'
        'api-server-start:Start API server'
        'api-server-stop:Stop API server'
        'api-server-status:Check API server status'
        'tools:Tool management commands'
    )

    _arguments -C \
        '-r[Reset configuration]' \
        '--resetconfig[Reset configuration]' \
        '-s[Source language]' \
        '--source[Source language]' \
        '-d[Destination language]' \
        '--destination[Destination language]' \
        '-c[Choose vendor]' \
        '--choosevendor[Choose vendor]' \
        '-m[Choose model]' \
        '--choosemodel[Choose model]' \
        '--mode[Prompt mode (code/chat/agent/report)]' \
        '-b[Debug mode]' \
        '--debug[Debug mode]' \
        '-a[API mode]' \
        '--api[API mode]' \
        '-e[Auto execute]' \
        '--autoexecute[Auto execute]' \
        '--auto-analyze[Toggle auto code analysis and improvement feature]' \
        '--auto-provider[Toggle auto provider selection feature]' \
        '-o[Output file]' \
        '--output[Output file]' \
        '-g[GUI mode]' \
        '--gui[GUI mode]' \
        '--execute-python[Execute Python file]' \
        '-p[Python command]' \
        '--python-command[Python command]' \
        '--list-cache[List cache]' \
        '--run-cache[Run cache]' \
        '--chat[Enable chat mode with optional message]:message:' \
        '--code[Enable code generation mode with optional prompt]:prompt:' \
        '--agent[Enable agent mode]' \
        '--report[Enable report generation mode]' \
        '--task[Execute a task with AI assistance]' \
        '--template[Specify report template]' \
        '--rag[Enable RAG feature]' \
        '--user[Specify user ID for RAG search]' \
        '--web[Enable web search]' \
        '--auto[Enable auto execution]' \
        '--format[Output format (pdf/hwpx/docx/pptx)]' \
        '--nocache[Disable web search and RAG search cache]' \
        '-v[Show detailed output]' \
        '--verbose[Show detailed output]' \
        '-q[Minimize output]' \
        '--quiet[Minimize output]' \
        '-h[Help]' \
        '--help[Help]' \
        '-V[Version]' \
        '--version[Version]' \
        "1: :->cmds" \
        "*::arg:->args"

    case "$state" in
        cmds)
            _describe "airun command" commands
            ;;
        args)
            case $line[1] in
                api-server-start)
                    _arguments \
                        '--port[Port number]:port:' \
                        '--host[Host address]:host:' \
                        '--foreground[Run in foreground mode]'
                    ;;
                clear-cache)
                    _arguments \
                        '--web-only[Clear only web search cache]' \
                        '--rag-only[Clear only RAG search cache]' \
                        '--report-only[Clear only report generation cache]' \
                        '--task-only[Clear only task cache]'
                    ;;
                tools)
                    _arguments \
                        '2:subcommand:(list info test create reload stats)' \
                        '3:toolName:' \
                        '--args[Test arguments (JSON format)]:json:'
                    ;;
                web-search)
                    _arguments \
                        '--engine[Search engine]:engine:(google naver daum parallel auto)' \
                        '--max-results[Maximum number of results]:number:' \
                        '2:query:'
                    ;;
                rag-add)
                    _arguments \
                        '--user[Specify user ID]:userId:' \
                        '2:path:_files -/'
                    ;;
                rag-remove)
                    _arguments \
                        '2:filePath:_files'
                    ;;
                rag-search)
                    _arguments \
                        '2:query:'
                    ;;
                rag-path)
                    _arguments \
                        '2:path:_files -/'
                    ;;
                task)
                    _arguments \
                        '2:message:'
                    ;;
                set)
                    _arguments \
                        '2:key:' \
                        '3:value:'
                    ;;
                *)
                    case "$line[1]" in
                        --mode)
                            _values 'mode' 'code' 'chat' 'agent' 'report'
                            ;;
                        --source|--destination)
                            _values 'language' 'ko' 'en' 'ja' 'zh' 'fr' 'de' 'es' 'it' 'ru' 'pt' 'hi' 'vi' 'auto'
                            ;;
                        --choosevendor)
                            _values 'vendor' 'openai' 'anthropic' 'gemini' 'groq' 'ollama' 'vllm'
                            ;;
                        --choosemodel)
                            _values 'model' \
                                'llama-3.1-405b-reasoning' 'llama-3.1-70b-versatile' \
                                'llama3-8b-8192' 'llama3-70b-8192' 'mixtral-8x7b-32768' \
                                'gemma-7b-it' 'llama3:latest' 'llama3:8b-instruct-q8_0' \
                                'llama3:70b' 'gemini-1.5-pro' 'gemini-1.5-flash' 'gemini-2.0-flash-exp' \
                                'gpt-4o' 'gpt-4o-mini' 'gpt-4-turbo' 'gpt-4' 'gpt-3.5-turbo' \
                                'claude-3-5-sonnet-20241022' 'claude-3-opus-20240229' 'claude-3-haiku-20240307'
                            ;;
                        --format)
                            _values 'format' 'pdf' 'hwpx' 'docx' 'pptx'
                            ;;
                        --template)
                            _values 'template' 'simple' 'bizplan' 'proposal' 'startup' 'thesis'
                            ;;
                        --chat)
                            # Chat mode with optional message - no specific completion needed
                            ;;
                        --code)
                            # Code generation mode with optional prompt - no specific completion needed
                            ;;
                        --execute-python)
                            _files -g "*.py"
                            ;;
                        *)
                            _files
                            ;;
                    esac
                    ;;
            esac
            ;;
    esac
}

compdef _airun airun 