/**
 * @swagger
 * tags:
 *   - name: Agent
 *     description: 에이전트 관련 API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     AgentRequest:
 *       type: object
 *       required:
 *         - prompt
 *         - type
 *       properties:
 *         prompt:
 *           type: string
 *           description: 에이전트에게 전달할 작업 지시 프롬프트
 *         type:
 *           type: string
 *           description: 세션 타입 (agent)
 *           example: agent
 *         options:
 *           type: object
 *           properties:
 *             agent_id:
 *               type: string
 *               description: 에이전트 세션 ID
 *             temperature:
 *               type: number
 *               description: 응답의 창의성 정도 (0.0 ~ 1.0)
 *             rag:
 *               type: boolean
 *               description: RAG 기능 사용 여부
 *             web:
 *               type: boolean
 *               description: 웹 검색 기능 사용 여부
 *     AgentResponse:
 *       type: object
 *       properties:
 *         success:
 *           type: boolean
 *         data:
 *           type: object
 *           properties:
 *             code:
 *               type: string
 *               description: 생성된 코드
 *             output:
 *               type: string
 *               description: 코드 실행 결과
 *             error:
 *               type: string
 *               description: 오류 메시지 (있는 경우)
 *             timestamp:
 *               type: string
 *               format: date-time
 */

/**
 * @swagger
 * /api/v1/agent:
 *   post:
 *     summary: 에이전트 작업 실행
 *     description: AI 에이전트에게 작업을 지시하고 실행합니다.
 *     tags: [Agent]
 *     security:
 *       - apiKeyAuth: []
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/AgentRequest'
 *           example:
 *             prompt: "현재 시스템의 디스크 사용량을 분석해서 출력"
 *             type: agent
 *             options:
 *               rag: false
 *               web: false 
 *     responses:
 *       200:
 *         description: 성공적인 응답
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/AgentResponse'
 *       401:
 *         description: 인증 실패
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 *       400:
 *         description: 잘못된 요청
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 */

/**
 * @swagger
 * /api/v1/agent/status/{jobId}:
 *   get:
 *     summary: 에이전트 작업 상태 확인
 *     description: 에이전트 작업의 처리 상태를 확인합니다.
 *     tags: [Agent]
 *     security:
 *       - apiKeyAuth: []
 *     parameters:
 *       - in: path
 *         name: jobId
 *         required: true
 *         schema:
 *           type: string
 *         description: 작업 ID
 *     responses:
 *       200:
 *         description: 작업 상태 정보
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                 data:
 *                   type: object
 *                   properties:
 *                     jobId:
 *                       type: string
 *                     state:
 *                       type: string
 *                       enum: [completed, failed, active, waiting, delayed]
 *                     code:
 *                       type: string
 *                     output:
 *                       type: string
 *                     message:
 *                       type: string
 *                     timestamp:
 *                       type: string
 *                       format: date-time
 */

export const agentSchemas = {
    AgentRequest: {
        type: 'object',
        required: ['prompt', 'type'],
        properties: {
            prompt: {
                type: 'string',
                description: '에이전트에게 전달할 작업 지시 프롬프트'
            },
            type: {
                type: 'string',
                description: '세션 타입 (agent)',
                example: 'agent'
            },
            options: {
                type: 'object',
                properties: {
                    agent_id: {
                        type: 'string',
                        description: '에이전트 세션 ID'
                    },
                    temperature: {
                        type: 'number',
                        description: '응답의 창의성 정도 (0.0 ~ 1.0)'
                    },
                    rag: {
                        type: 'boolean',
                        description: 'RAG 기능 사용 여부'
                    },
                    web: {
                        type: 'boolean',
                        description: '웹 검색 기능 사용 여부'
                    }
                }
            }
        }
    }
}; 