import React from 'react';
import { 
  EdgeProps, 
  getSmoothStepPath, 
  EdgeLabelRenderer,
  BaseEdge,
  Edge,
  MarkerType
} from 'reactflow';
import { X } from 'lucide-react';

interface CustomEdgeData {
  onDelete?: (edgeId: string) => void;
}

export default function CustomEdge({
  id,
  sourceX,
  sourceY,
  targetX,
  targetY,
  sourcePosition,
  targetPosition,
  style = {},
  data,
  markerEnd,
  selected,
}: EdgeProps<CustomEdgeData>) {
  const [edgePath, labelX, labelY] = getSmoothStepPath({
    sourceX,
    sourceY,
    sourcePosition,
    targetX,
    targetY,
    targetPosition,
    borderRadius: 0,
  });

  const onEdgeClick = () => {
    if (data?.onDelete) {
      data.onDelete(id);
    }
  };

  return (
    <>
      <BaseEdge 
        path={edgePath} 
        markerEnd={markerEnd}
        style={{
          stroke: selected ? '#3b82f6' : '#64748b',
          strokeWidth: selected ? 3 : 2,
          strokeLinecap: 'round',
          strokeDasharray: '5 5',
          strokeDashoffset: '0',
          animation: 'flowingDash 1.5s linear infinite',
          ...style,
        }}
      />
      <style jsx>{`
        @keyframes flowingDash {
          0% { stroke-dashoffset: 0; }
          100% { stroke-dashoffset: -20px; }
        }
      `}</style>
      <EdgeLabelRenderer>
        <div
          style={{
            position: 'absolute',
            transform: `translate(-50%, -50%) translate(${labelX}px,${labelY}px)`,
            fontSize: 12,
            pointerEvents: 'all',
          }}
          className="nodrag nopan"
        >
          <button
            className="w-6 h-6 bg-red-500 hover:bg-red-600 text-white rounded-full flex items-center justify-center shadow-lg transition-all duration-150 hover:scale-110 opacity-0 hover:opacity-100"
            onClick={onEdgeClick}
            title="연결 삭제"
            style={{
              opacity: selected ? 1 : 0,
            }}
            onMouseEnter={(e) => e.currentTarget.style.opacity = '1'}
            onMouseLeave={(e) => e.currentTarget.style.opacity = selected ? '1' : '0'}
          >
            <X className="w-3 h-3" />
          </button>
        </div>
      </EdgeLabelRenderer>
    </>
  );
}