# 예제 태스크 및 샘플 데이터

이 디렉토리에는 utils.py의 기능을 활용한 자동화 태스크 예제와 필요한 샘플 데이터가 포함되어 있습니다.

## 디렉토리 구조
```
examples/
├── tasks/                    # 태스크 정의 파일들
│   ├── task1.txt            # 매출 데이터 분석
│   ├── task2.txt            # 법률 문서 분석
│   └── ...
├── data/                     # 샘플 데이터 파일들
│   ├── sales/               # 매출 데이터 관련
│   │   ├── sales_data.xlsx
│   │   └── sales_report_template.pdf
│   ├── legal/               # 법률 문서 관련
│   │   ├── contract1.hwp
│   │   ├── contract2.hwp
│   │   └── contract_template.pdf
│   ├── manuals/             # 제품 매뉴얼 관련
│   │   ├── product_manual_ko.hwp
│   │   └── term_glossary.xlsx
│   ├── feedback/            # 고객 피드백 관련
│   │   ├── customer_emails.csv
│   │   └── app_reviews.json
│   ├── security/            # 보안 로그 관련
│   │   ├── server_access.log
│   │   └── firewall.log
│   └── education/           # 교육 콘텐츠 관련
│       ├── course_material.md
│       └── quiz_bank.json
└── scripts/                 # 실행 스크립트
    ├── task1_runner.py      # 태스크1 실행 스크립트
    ├── task2_runner.py      # 태스크2 실행 스크립트
    └── ...
```

## 사용 방법

1. 필요한 샘플 데이터 파일을 `data/` 디렉토리의 해당 하위 폴더에 위치시킵니다.
2. 각 태스크의 실행 스크립트를 `scripts/` 디렉토리에서 찾아 실행합니다.
3. 결과물은 각 태스크의 output 디렉토리에 생성됩니다.

## 주의사항

- 샘플 데이터는 테스트 목적으로만 사용됩니다.
- 실제 운영 환경에서는 적절한 데이터로 교체하여 사용하세요.
- 이메일 발송 기능을 사용하기 전에 이메일 설정을 완료해야 합니다. 