import TaskStatus from './TaskStatus.js';

class TaskStep {
    constructor({id, number, description, dependencies = [], request, status = TaskStatus.NOT_STARTED}) {
        this.id = id;
        this.number = number;
        this.description = description;
        this.status = status;
        this.dependencies = dependencies;
        this.request = request;
        this.result = null;
        this.error = null;
        this.startTime = null;
        this.endTime = null;
        this.createdAt = new Date();
        this.completedAt = null;
        this.context = {};
    }

    setStatus(status) {
        this.status = status;
        if (status === TaskStatus.IN_PROGRESS) {
            this.startTime = new Date().toISOString();
        } else if (status === TaskStatus.COMPLETED || status === TaskStatus.FAILED) {
            this.endTime = new Date().toISOString();
            if (status === TaskStatus.COMPLETED) {
                this.completedAt = new Date();
            }
        }
    }

    setResult(result) {
        this.result = result;
    }

    setError(error) {
        this.error = error;
        this.setStatus(TaskStatus.FAILED);
    }

    toJSON() {
        return {
            id: this.id,
            number: this.number,
            description: this.description,
            status: this.status,
            dependencies: this.dependencies,
            result: this.result,
            error: this.error,
            startTime: this.startTime,
            endTime: this.endTime,
            createdAt: this.createdAt,
            completedAt: this.completedAt
        };
    }
}

export default TaskStep; 