#!/bin/bash

# -------------------------------
# 모델 설정
# -------------------------------
# Tested:
# sh2orc/Llama-3-Korean-8B
# moreh/Llama-3-Motif-102B-Instruct
# RedHatAI/Llama-4-Scout-17B-16E-Instruct-quantized.w4a16
# Bllossom/llama-3.2-Korean-Bllossom-AICA-5B

MODEL_NAME="sh2orc/Llama-3-Korean-8B"
PORT=11400
DOWNLOAD_DIR="/home/work/airun_fs/models"

# -------------------------------
# 실행 환경 설정
# -------------------------------
VENV_ACTIVATE="/home/work/airun_fs/.venv/bin/activate"
PYTHON_BIN="/home/work/airun_fs/.venv/bin/python"

# -------------------------------
# 로그 경로 설정
# -------------------------------
LOG_DIR="./logs"
LOG_FILE="${LOG_DIR}/vllm_$(date +%Y%m%d_%H%M%S).log"
mkdir -p "$LOG_DIR"

# -------------------------------
# 실행 명령
# -------------------------------
echo "[INFO] Running vLLM API Server"
echo "[INFO] Model: $MODEL_NAME"
echo "[INFO] Port: $PORT"
echo "[INFO] Logs: $LOG_FILE"

# 가상환경 활성화
source "$VENV_ACTIVATE"

# 백그라운드 실행
nohup $PYTHON_BIN -m vllm.entrypoints.openai.api_server \
  --model "$MODEL_NAME" \
  --download-dir "$DOWNLOAD_DIR" \
  --port "$PORT" \
  --host 0.0.0.0 \
  > "$LOG_FILE" 2>&1 &

