import { NextRequest, NextResponse } from 'next/server';

export async function GET(request: NextRequest) {
  try {
    const apiServerUrl = process.env.NEXT_PUBLIC_API_SERVER_URL;
    
    if (!apiServerUrl) {
      return NextResponse.json(
        { success: false, error: 'API 서버 URL이 설정되지 않았습니다.' },
        { status: 500 }
      );
    }

    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 5000);
    
    const response = await fetch(`${apiServerUrl}/health`, {
      method: 'GET',
      signal: controller.signal,
      headers: {
        'ngrok-skip-browser-warning': 'true'
      }
    });
    
    clearTimeout(timeoutId);
    
    if (response.ok) {
      return NextResponse.json({ 
        success: true, 
        status: 'online',
        url: apiServerUrl 
      });
    } else {
      return NextResponse.json({ 
        success: false, 
        status: 'offline',
        url: apiServerUrl 
      });
    }
  } catch (error) {
    console.error('서버 상태 확인 중 오류:', error);
    
    return NextResponse.json({ 
      success: false, 
      status: 'offline',
      url: process.env.NEXT_PUBLIC_API_SERVER_URL,
      error: error instanceof Error ? error.message : '알 수 없는 오류'
    });
  }
} 