
#!/bin/bash

CONTAINER_NAME="open-webui"
IMAGE_NAME="ghcr.io/open-webui/open-webui:main"
PORTS="-p 5900:8080"
ENV_VARS="-e OLLAMA_BASE_URL=https://profound-balanced-mammoth.ngrok-free.app"
VOLUME="-v open-webui:/app/backend/data"

# Check if container exists
if [ "$(docker ps -a -q -f name=^/${CONTAINER_NAME}$)" ]; then
  echo "Starting existing container: ${CONTAINER_NAME}"
  docker start ${CONTAINER_NAME}
else
  echo "Creating and running new container: ${CONTAINER_NAME}"
  docker run -d ${PORTS} ${ENV_VARS} ${VOLUME} --name ${CONTAINER_NAME} --restart always ${IMAGE_NAME}
fi

# Tika server
docker run -d \
  -p 9998:9998 \
  --name tika-server \
  apache/tika:latest
