import { dialog, app } from 'electron';
import { getMainWindow } from './index.js';
import { setVarVal } from '../../configuration.js';

export const selectDirectory = async (options = {}) => {
    try {
        const window = getMainWindow();
        if (!window) {
            throw new Error('No active window found');
        }
        
        const result = await dialog.showOpenDialog(window, {
            title: options.title || '디렉토리 선택',
            defaultPath: options.defaultPath || app.getPath('documents'),
            properties: ['openDirectory', 'createDirectory'],
            buttonLabel: 'Select'
        });
        
        if (result.filePaths && result.filePaths.length > 0) {
            const selectedPath = result.filePaths[0];
            
            if (options.configKey) {
                await setVarVal(options.configKey, selectedPath, true);
                window.webContents.send('settings-updated', {
                    key: options.configKey,
                    value: selectedPath
                });
            }
            
            return {
                success: true,
                filePath: selectedPath,
                canceled: false
            };
        }
        
        return {
            success: false,
            canceled: true
        };
    } catch (error) {
        console.error('Directory selection error:', error);
        throw error;
    }
}; 