import { BrowserWindow, Menu, app, session, globalShortcut } from 'electron';
import { fileURLToPath } from 'url';
import { dirname, join } from 'path';
import path from 'path';
import open from 'open';
import { devmode } from '../../constants.js';

const __filename = fileURLToPath(import.meta.url);
const __dirname = dirname(__filename);

export const createMainWindow = async () => {
    const win = new BrowserWindow({
        show: false,
        webPreferences: {
            preload: path.join(dirname(dirname(__dirname)), 'static/preload.mjs'),
            sandbox: false,
            contextIsolation: true,
            nodeIntegration: true,
            webSecurity: false,
            allowRunningInsecureContent: true
        },
        icon: path.join(dirname(dirname(__dirname)), 'assets/icon.png'),
        backgroundColor: '#1e1e1e',
        width: 1280,
        height: 1000,
        minWidth: 640,
        minHeight: 480,    
    });

    // CSP 헤더 설정
    session.defaultSession.webRequest.onHeadersReceived((details, callback) => {
        callback({
            responseHeaders: {
                ...details.responseHeaders,
                'Content-Security-Policy': [
                    "default-src 'self' https: http: data: ws: wss: 'unsafe-inline' 'unsafe-eval';",
                    "script-src 'self' https: http: 'unsafe-inline' 'unsafe-eval' https://*.youtube.com https://accounts.google.com;",
                    "style-src 'self' https: http: 'unsafe-inline';",
                    "img-src 'self' https: http: data: blob:;",
                    "connect-src 'self' https: http: ws: wss:;",
                    "frame-src 'self' https://*.youtube.com https://accounts.google.com;",
                    "form-action 'self' https://accounts.google.com;"
                ]
            }
        });
    });

    // 메뉴 설정
    const menuTemplate = [
        {
            label: 'App',
            submenu: [
                {
                    label: 'About',
                    click: async () => {
                        await open('https://hamonikr.org');
                    }
                },
                { type: 'separator' },
                {
                    role: 'quit',
                    accelerator: 'CommandOrControl+Q'
                }
            ]
        },
        {
            label: 'Edit',
            submenu: [
                { role: 'undo', accelerator: 'CommandOrControl+Z' },
                { role: 'redo', accelerator: 'Shift+CommandOrControl+Z' },
                { type: 'separator' },
                { role: 'cut', accelerator: 'CommandOrControl+X' },
                { role: 'copy', accelerator: 'CommandOrControl+C' },
                { role: 'paste', accelerator: 'CommandOrControl+V' },
                { role: 'pasteandmatchstyle' },
                { role: 'selectall', accelerator: 'CommandOrControl+A' }
            ]
        },
        {
            label: 'View',
            submenu: devmode ? [
                {
                    role: 'reload',
                    accelerator: 'CommandOrControl+R'
                },
                {
                    role: 'toggledevtools',
                    accelerator: 'Alt+CommandOrControl+I'
                },
                { role: 'resetzoom' },
                { role: 'zoomin' },
                { role: 'zoomout' },
                { type: 'separator' },
                { role: 'togglefullscreen' }
            ] : [
                { role: 'resetzoom' },
                { role: 'zoomin' },
                { role: 'zoomout' },
                { type: 'separator' },
                { role: 'togglefullscreen' }
            ]
        }
    ];

    const menu = Menu.buildFromTemplate(menuTemplate);
    Menu.setApplicationMenu(menu);

    win.loadFile(path.join(dirname(dirname(__dirname)), 'index.html'));
    
    win.once('ready-to-show', () => {
        win.show();
        if (devmode) win.webContents.openDevTools();
    });

    // 개발자 도구 단축키 비활성화 (프로덕션 모드에서만)
    if (!devmode) {
        globalShortcut.register('CommandOrControl+Shift+I', () => {});
        globalShortcut.register('CommandOrControl+Option+I', () => {});
        globalShortcut.register('F5', () => {});
        globalShortcut.register('CommandOrControl+R', () => {});
    }

    return win;
}; 