# 파이썬 프로그래밍 기초

## 1. 파이썬 소개
파이썬은 간단하고 배우기 쉬운 프로그래밍 언어입니다. 데이터 분석, 웹 개발, 인공지능 등 다양한 분야에서 활용됩니다.

### 주요 특징
- 읽기 쉬운 문법
- 풍부한 라이브러리
- 강력한 커뮤니티 지원
- 크로스 플랫폼 지원

## 2. 개발 환경 설정
1. Python 설치
2. IDE 선택 및 설치
3. 가상환경 설정

## 3. 기본 문법
```python
# 변수 선언
name = "홍길동"
age = 25

# 조건문
if age >= 20:
    print("성인입니다")
else:
    print("미성년자입니다")

# 반복문
for i in range(5):
    print(f"{i}번째 반복")
```

## 4. 자료구조
- 리스트
- 튜플
- 딕셔너리
- 집합

## 5. 함수
```python
def greet(name):
    return f"안녕하세요, {name}님!"

# 함수 호출
message = greet("홍길동")
print(message)
```

## 6. 실습 과제
1. 간단한 계산기 만들기
2. 주소록 관리 프로그램 만들기
3. 파일 입출력 실습 