/**
 * @swagger
 * tags:
 *   - name: Code
 *     description: 코드 생성 관련 API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     CodeRequest:
 *       type: object
 *       required:
 *         - prompt
 *         - type
 *       properties:
 *         prompt:
 *           type: string
 *           description: 코드 생성을 위한 프롬프트
 *         type:
 *           type: string
 *           description: 세션 타입 (code)
 *           example: code
 *         options:
 *           type: object
 *           properties:
 *             language:
 *               type: string
 *               description: 생성할 코드의 프로그래밍 언어
 *               default: python
 *             temperature:
 *               type: number
 *               description: 응답의 창의성 정도 (0.0 ~ 1.0)
 *             sessionId:
 *               type: string
 *               description: 세션 ID
 *             autoExecute:
 *               type: boolean
 *               description: 코드 자동 실행 여부
 *             hideCode:
 *               type: boolean
 *               description: 코드 숨김 여부
 *     CodeResponse:
 *       type: object
 *       properties:
 *         success:
 *           type: boolean
 *         data:
 *           type: object
 *           properties:
 *             code:
 *               type: string
 *             output:
 *               type: string
 *             error:
 *               type: string
 *             timestamp:
 *               type: string
 *               format: date-time
 */

/**
 * @swagger
 * /api/v1/code:
 *   post:
 *     summary: 코드 생성
 *     description: 프롬프트를 기반으로 코드를 생성합니다.
 *     tags: [Code]
 *     security:
 *       - apiKeyAuth: []
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/CodeRequest'
 *           example:
 *             prompt: "1부터 10까지 더하는 파이썬 코드를 작성해주세요"
 *             type: code
 *             options:
 *               rag: false
 *               web: false 
 *     responses:
 *       200:
 *         description: 성공적인 응답
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/CodeResponse'
 *       401:
 *         description: 인증 실패
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 *       400:
 *         description: 잘못된 요청
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 */

/**
 * @swagger
 * /api/v1/code/status/{jobId}:
 *   get:
 *     operationId: getCodeStatus
 *     summary: 코드 생성 작업 상태 확인
 *     description: 코드 생성 요청의 처리 상태를 확인합니다.
 *     tags: [Code]
 *     security:
 *       - apiKeyAuth: []
 *     parameters:
 *       - in: path
 *         name: jobId
 *         required: true
 *         schema:
 *           type: string
 *         description: 작업 ID
 *     responses:
 *       200:
 *         description: 작업 상태 정보
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                 data:
 *                   type: object
 *                   properties:
 *                     jobId:
 *                       type: string
 *                     state:
 *                       type: string
 *                       enum: [completed, failed, active, waiting, delayed]
 *                     code:
 *                       type: string
 *                     output:
 *                       type: string
 *                     message:
 *                       type: string
 *                     timestamp:
 *                       type: string
 *                       format: date-time
 */

/**
 * @swagger
 * /api/v1/code/sync:
 *   post:
 *     summary: 코드 생성 요청 (동기식)
 *     description: AI에게 코드 생성을 요청하고 응답을 즉시 받습니다. 비동기 처리가 필요 없는 경우 사용합니다.
 *     tags: [Code]
 *     security:
 *       - apiKeyAuth: []
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             required:
 *               - prompt
 *             properties:
 *               prompt:
 *                 type: string
 *                 description: 코드 생성 요청 텍스트
 *               type:
 *                 type: string
 *                 description: 세션 타입 (code)
 *                 example: code
 *               options:
 *                 type: object
 *                 properties:
 *                   language:
 *                     type: string
 *                     description: 프로그래밍 언어 (기본값 python)
 *                   temperature:
 *                     type: number
 *                     description: 응답의 창의성 정도 (0.0 ~ 1.0)
 *                   sessionId:
 *                     type: string
 *                     description: 채팅 세션 ID
 *                   hideCode:
 *                     type: boolean
 *                     description: 코드 숨김 여부
 *                   autoExecute:
 *                     type: boolean
 *                     description: 자동 실행 여부
 *                   rag:
 *                     type: boolean
 *                     description: RAG 기능 사용 여부
 *                   web:
 *                     type: boolean
 *                     description: 웹 검색 기능 사용 여부
 *           example:
 *             prompt: "1부터 10까지 더하는 파이썬 코드를 작성해주세요"
 *             type: code
 *             options:
 *               rag: false
 *               web: false
 *               username: "admin"
 *     responses:
 *       200:
 *         description: 성공적인 응답
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                 data:
 *                   type: object
 *                   properties:
 *                     code:
 *                       type: string
 *                       description: 생성된 코드
 *                     output:
 *                       type: string
 *                       description: 코드 실행 결과
 *                     error:
 *                       type: string
 *                       nullable: true
 *                       description: 실행 중 발생한 오류
 *                     timestamp:
 *                       type: string
 *                       format: date-time
 *             example:
 *               success: true
 *               data:
 *                 code: "sum = 0\nfor i in range(1, 11):\n    sum += i\nprint(f'1부터 10까지의 합: {sum}')"
 *                 output: "1부터 10까지의 합: 55"
 *                 error: null
 *                 timestamp: "2025-04-22T02:45:12.345Z"
 *       401:
 *         description: 인증 실패
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 *       400:
 *         description: 잘못된 요청
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 */

export const codeSchemas = {
    CodeRequest: {
        type: 'object',
        required: ['prompt', 'type'],
        properties: {
            prompt: {
                type: 'string',
                description: '코드 생성을 위한 프롬프트'
            },
            type: {
                type: 'string',
                description: '세션 타입 (code)',
                example: 'code'
            },
            options: {
                type: 'object',
                properties: {
                    language: {
                        type: 'string',
                        description: '생성할 코드의 프로그래밍 언어',
                        default: 'python'
                    },
                    temperature: {
                        type: 'number',
                        description: '응답의 창의성 정도 (0.0 ~ 1.0)'
                    },
                    sessionId: {
                        type: 'string',
                        description: '세션 ID'
                    },
                    autoExecute: {
                        type: 'boolean',
                        description: '코드 자동 실행 여부'
                    },
                    hideCode: {
                        type: 'boolean',
                        description: '코드 숨김 여부'
                    },
                    username: {
                        type: 'string',
                        description: "사용자명 (권장 방식). 로그인한 사용자의 사용자명을 사용합니다."
                    },
                    userId: {
                        type: 'integer',
                        description: "사용자 ID (정수형, 하위 호환성용). username을 제공하지 않은 경우에만 사용됩니다."
                    }
                }
            }
        }
    }
}; 