/**
 * @swagger
 * components:
 *   schemas:
 *     Provider:
 *       type: object
 *       properties:
 *         key:
 *           type: string
 *           description: "프로바이더 키"
 *           example: "vllm"
 *         name:
 *           type: string
 *           description: "프로바이더 이름"
 *           example: "vLLM"
 *         requiresApiKey:
 *           type: boolean
 *           description: "API 키 필요 여부"
 *           example: false
 *         apiKeyConfigured:
 *           type: boolean
 *           description: "API 키 설정 여부"
 *           example: true
 *         isDynamic:
 *           type: boolean
 *           description: "동적 모델 로딩 지원 여부"
 *           example: true
 *         isAvailable:
 *           type: boolean
 *           description: "사용 가능 여부"
 *           example: true
 *         models:
 *           type: array
 *           items:
 *             $ref: '#/components/schemas/Model'
 *           description: "사용 가능한 모델 목록"
 * 
 *     Model:
 *       type: object
 *       properties:
 *         id:
 *           type: string
 *           description: "모델 ID"
 *           example: "unsloth/gemma-3-12b-it-unsloth-bnb-4bit"
 *         name:
 *           type: string
 *           description: "모델 이름"
 *           example: "unsloth/gemma-3-12b-it-unsloth-bnb-4bit"
 *         description:
 *           type: string
 *           description: "모델 설명"
 *           example: "vLLM 모델: unsloth/gemma-3-12b-it-unsloth-bnb-4bit"
 * 
 *     ProviderConfig:
 *       type: object
 *       properties:
 *         provider:
 *           type: string
 *           description: "현재 설정된 프로바이더"
 *           example: "vllm"
 *         model:
 *           type: string
 *           description: "현재 설정된 모델"
 *           example: "unsloth/gemma-3-12b-it-unsloth-bnb-4bit"
 *         timestamp:
 *           type: string
 *           format: date-time
 *           description: "설정 시간"
 *           example: "2024-01-15T10:30:00.000Z"
 * 
 *     ErrorResponse:
 *       type: object
 *       properties:
 *         success:
 *           type: boolean
 *           example: false
 *         error:
 *           type: object
 *           properties:
 *             code:
 *               type: string
 *               example: "PROVIDER_ERROR"
 *             message:
 *               type: string
 *               example: "프로바이더 오류가 발생했습니다."
 */

/**
 * @swagger
 * /api/v1/providers:
 *   get:
 *     summary: "모든 프로바이더 정보 조회"
 *     description: "설정된 모든 AI 프로바이더의 상세 정보를 조회합니다. (관리자 권한 필요)"
 *     tags: [Providers]
 *     security:
 *       - bearerAuth: []
 *     responses:
 *       200:
 *         description: "프로바이더 정보 조회 성공"
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: true
 *                 data:
 *                   type: object
 *                   additionalProperties:
 *                     $ref: '#/components/schemas/Provider'
 *       401:
 *         description: "인증 실패"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 *       403:
 *         description: "권한 없음 (관리자만 접근 가능)"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 */

/**
 * @swagger
 * /api/v1/providers/available:
 *   get:
 *     summary: "사용 가능한 프로바이더 목록 조회"
 *     description: "현재 설정되어 사용 가능한 AI 프로바이더 목록을 조회합니다."
 *     tags: [Providers]
 *     responses:
 *       200:
 *         description: "사용 가능한 프로바이더 목록 조회 성공"
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: true
 *                 data:
 *                   type: array
 *                   items:
 *                     $ref: '#/components/schemas/Provider'
 *       500:
 *         description: "서버 오류"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 */

/**
 * @swagger
 * /api/v1/providers/{providerKey}/models:
 *   get:
 *     summary: "특정 프로바이더의 모델 목록 조회"
 *     description: "지정된 프로바이더에서 사용 가능한 모델 목록을 조회합니다."
 *     tags: [Providers]
 *     parameters:
 *       - in: path
 *         name: providerKey
 *         required: true
 *         schema:
 *           type: string
 *         description: "프로바이더 키 (예: vllm, ollama, openai)"
 *         example: "vllm"
 *     responses:
 *       200:
 *         description: "모델 목록 조회 성공"
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: true
 *                 data:
 *                   type: array
 *                   items:
 *                     $ref: '#/components/schemas/Model'
 *       404:
 *         description: "프로바이더를 찾을 수 없음"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 *       500:
 *         description: "서버 오류"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 */

/**
 * @swagger
 * /api/v1/providers/config:
 *   get:
 *     summary: "현재 프로바이더 설정 조회"
 *     description: "현재 설정된 프로바이더와 모델 정보를 조회합니다."
 *     tags: [Providers]
 *     security:
 *       - bearerAuth: []
 *     responses:
 *       200:
 *         description: "현재 설정 조회 성공"
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: true
 *                 data:
 *                   $ref: '#/components/schemas/ProviderConfig'
 *       401:
 *         description: "인증 실패"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 *       403:
 *         description: "권한 없음 (관리자만 접근 가능)"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 */

/**
 * @swagger
 * /api/v1/providers/{providerKey}/validate:
 *   post:
 *     summary: "프로바이더 설정 검증"
 *     description: "지정된 프로바이더의 설정이 올바른지 검증합니다."
 *     tags: [Providers]
 *     security:
 *       - bearerAuth: []
 *     parameters:
 *       - in: path
 *         name: providerKey
 *         required: true
 *         schema:
 *           type: string
 *         description: "프로바이더 키"
 *         example: "vllm"
 *     responses:
 *       200:
 *         description: "검증 성공"
 *         content:
 *           application/json:
 *             schema:
 *               type: object
 *               properties:
 *                 success:
 *                   type: boolean
 *                   example: true
 *                 data:
 *                   type: object
 *                   properties:
 *                     valid:
 *                       type: boolean
 *                       example: true
 *                     message:
 *                       type: string
 *                       example: "프로바이더 설정이 올바릅니다."
 *       401:
 *         description: "인증 실패"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 *       403:
 *         description: "권한 없음 (관리자만 접근 가능)"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 *       404:
 *         description: "프로바이더를 찾을 수 없음"
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ErrorResponse'
 */

export default {}; 