import { NextRequest, NextResponse } from 'next/server';
import { clearTokenCookie } from '../utils';
import { getApiServerUrl } from '@/config/serverConfig';

export async function POST(request: NextRequest) {
  try {
    const API_SERVER = getApiServerUrl();
    const token = request.cookies.get('auth_token')?.value;
    
    // API 서버에 로그아웃 요청 (선택적, 토큰이 있는 경우)
    if (token) {
      try {
        console.log('API 서버에 로그아웃 요청:', `${API_SERVER}/auth/logout`);
        
        const response = await fetch(`${API_SERVER}/auth/logout`, {
          method: 'POST',
          headers: {
            'Authorization': `Bearer ${token}`
          }
        });
        
        if (!response.ok) {
          console.warn('API 서버 로그아웃 응답 오류:', {
            status: response.status,
            statusText: response.statusText
          });
        } else {
          console.log('API 서버 로그아웃 성공');
        }
      } catch (err) {
        console.error('API 서버 로그아웃 요청 오류:', err);
        // 계속 진행 - 클라이언트 측 로그아웃은 여전히 수행
      }
    } else {
      console.log('토큰이 없어 API 서버 로그아웃 요청을 건너뜁니다.');
    }
    
    // 응답 생성
    const response = NextResponse.json({
      success: true,
      message: '로그아웃되었습니다.'
    });
    
    // 쿠키에서 토큰 삭제
    clearTokenCookie(response);
    console.log('클라이언트 쿠키에서 토큰이 삭제되었습니다.');
    
    return response;
  } catch (error) {
    console.error('로그아웃 처리 중 오류:', error);
    return NextResponse.json(
      {
        success: false,
        error: {
          message: '로그아웃 처리 중 오류가 발생했습니다.'
        }
      },
      { status: 500 }
    );
  }
} 