import { NextResponse } from 'next/server';
import fs from 'fs';
import path from 'path';

const STATUS_FILE = path.join(process.cwd(), 'eval_status.json');

export async function GET() {
  try {
    if (!fs.existsSync(STATUS_FILE)) {
      return NextResponse.json({
        isRunning: false,
        progress: 0,
        currentModel: '',
        currentCategory: '',
        totalModels: 0,
        completedModels: 0,
      });
    }
    
    const data = fs.readFileSync(STATUS_FILE, 'utf-8');
    const status = JSON.parse(data);
    
    return NextResponse.json(status);
  } catch (error) {
    console.error('평가 상태 조회 오류:', error);
    return NextResponse.json({
      isRunning: false,
      progress: 0,
      error: '상태를 조회할 수 없습니다.'
    }, { status: 500 });
  }
} 