import { NextResponse } from 'next/server';
import fs from 'fs';
import path from 'path';

const STATUS_FILE = path.join(process.cwd(), 'eval_status.json');

export async function POST() {
  try {
    // 평가 상태를 중단으로 변경
    const currentStatus = fs.existsSync(STATUS_FILE) 
      ? JSON.parse(fs.readFileSync(STATUS_FILE, 'utf-8'))
      : {};

    const updatedStatus = {
      ...currentStatus,
      isRunning: false,
      isStopped: true,
      error: '사용자에 의해 평가가 중단되었습니다.',
      endTime: new Date().toISOString(),
      stoppedAt: new Date().toISOString()
    };

    fs.writeFileSync(STATUS_FILE, JSON.stringify(updatedStatus, null, 2));

    return NextResponse.json({ 
      message: '평가가 중단되었습니다.',
      status: updatedStatus
    });
  } catch (error) {
    console.error('평가 중단 오류:', error);
    return NextResponse.json({ 
      error: '평가 중단 중 오류가 발생했습니다.' 
    }, { status: 500 });
  }
} 