import { NextResponse } from 'next/server';

const VLLM_SERVER = process.env.NEXT_PUBLIC_VLLM_SERVER || "https://api.hamonize.com/vllm";

export async function GET() {
  try {
    // VLLM 모델 목록 조회
    const response = await fetch(`${VLLM_SERVER}/v1/models`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    });

    if (!response.ok) {
      throw new Error(`VLLM API 오류: ${response.status}`);
    }

    const data = await response.json();
    const models = data.data?.map((model: any) => ({
      name: model.id,
      object: model.object,
      created: model.created,
      owned_by: model.owned_by,
      type: 'vllm'
    })) || [];

    return NextResponse.json({ models });
  } catch (error) {
    console.error('VLLM 모델 목록 조회 오류:', error);
    return NextResponse.json({ 
      models: [],
      error: 'VLLM 모델 목록을 조회할 수 없습니다.' 
    }, { status: 500 });
  }
} 