import { NextRequest, NextResponse } from 'next/server';

const LLM_FINETUNE_BASE_URL = process.env.NEXT_PUBLIC_LLM_FINETUNE_API_SERVER || 'http://localhost:5630';

export async function POST(request: NextRequest) {
  try {
    const body = await request.json();
    
    const response = await fetch(`${LLM_FINETUNE_BASE_URL}/playground/chat`, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
      },
      body: JSON.stringify(body),
    });

    const data = await response.json();
    return NextResponse.json(data);
  } catch (error) {
    console.error('Chat error:', error);
    return NextResponse.json(
      { success: false, error: 'Failed to process chat message' },
      { status: 500 }
    );
  }
}