/** @type {import('tailwindcss').Config} */
module.exports = {
  darkMode: 'class',
  content: [
    './src/pages/**/*.{js,ts,jsx,tsx,mdx}',
    './src/components/**/*.{js,ts,jsx,tsx,mdx}',
    './src/app/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      fontFamily: {
        'sans': ['"Spoqa Han Sans Neo"', '-apple-system', 'BlinkMacSystemFont', 'system-ui', 'Roboto', '"Helvetica Neue"', '"Segoe UI"', '"Apple SD Gothic Neo"', '"Noto Sans KR"', '"Malgun Gothic"', 'sans-serif'],
        'spoqa': ['"Spoqa Han Sans Neo"', 'sans-serif'],
      },
      colors: {
        'background': 'var(--background)',
        'foreground': 'var(--foreground)',
        'card-bg': 'var(--card-bg)',
        'card-border': 'var(--card-border)',
        'header-bg': 'var(--header-bg)',
        'footer-bg': 'var(--footer-bg)',
        'body-bg': 'var(--body-bg)',
        'link-color': 'var(--link-color)',
        'link-hover': 'var(--link-hover)',
        'text-primary': 'var(--text-primary)',
        'text-secondary': 'var(--text-secondary)',
        'text-muted': 'var(--text-muted)',
        'button-bg': 'var(--button-bg)',
        'button-text': 'var(--button-text)',
        'button-hover': 'var(--button-hover)',
      },
      fontSize: {
        'tiny': '13px',
      },
    },
  },
  plugins: [
    require('@tailwindcss/typography'),
    function ({ addUtilities }) {
      const newUtilities = {
        '.scrollbar-hide': {
          /* IE and Edge */
          '-ms-overflow-style': 'none',
          /* Firefox */
          'scrollbar-width': 'none',
          /* Chrome, Safari and Opera */
          '&::-webkit-scrollbar': {
            display: 'none'
          }
        },
      };
      addUtilities(newUtilities);
    }
  ],
}
