#!/bin/bash

URL="https://proxy5.aitrain.ktcloud.com:10407/"
LOGFILE="/var/log/keep_session.log"

echo "[INFO] Starting session keeper at $(date)" >> "$LOGFILE"

while true; do
  TIMESTAMP=$(date '+%Y-%m-%d %H:%M:%S')
  
  # 요청
  RESPONSE=$(curl -sk -o /dev/null -w "%{http_code}" "$URL")
  
  echo "[$TIMESTAMP] Request to $URL → Response: $RESPONSE" >> "$LOGFILE"
  
  # 30분 대기 (1800초)
  sleep 1800
done

