/**
 * @swagger
 * tags:
 *   - name: System
 *     description: 시스템 관련 API
 */

/**
 * @swagger
 * components:
 *   schemas:
 *     HealthResponse:
 *       type: object
 *       properties:
 *         success:
 *           type: boolean
 *         status:
 *           type: string
 *           example: ok
 *         uptime:
 *           type: number
 *           description: 서버 실행 시간(초)
 *         timestamp:
 *           type: string
 *           format: date-time
 *     ConfigResponse:
 *       type: object
 *       properties:
 *         success:
 *           type: boolean
 *         key:
 *           type: string
 *         value:
 *           type: string
 *         timestamp:
 *           type: string
 *           format: date-time
 *     ConfigUpdateRequest:
 *       type: object
 *       required:
 *         - key
 *       properties:
 *         key:
 *           type: string
 *           description: 설정 키
 *         value:
 *           type: string
 *           description: 설정 값
 *     ConfigUpdateResponse:
 *       type: object
 *       properties:
 *         success:
 *           type: boolean
 *         key:
 *           type: string
 *         value:
 *           type: string
 *         result:
 *           type: string
 *         timestamp:
 *           type: string
 *           format: date-time
 */

/**
 * @swagger
 * /api/v1/health:
 *   get:
 *     summary: 서버 상태 확인
 *     description: API 서버의 현재 상태를 확인합니다.
 *     tags: [System]
 *     responses:
 *       200:
 *         description: 서버 상태 정보
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/HealthResponse'
 *       400:
 *         description: 잘못된 요청
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 */

/**
 * @swagger
 * /api/v1/config/{key}:
 *   get:
 *     summary: 설정 조회
 *     description: 특정 설정 키의 값을 조회합니다.
 *     tags: [System]
 *     parameters:
 *       - in: path
 *         name: key
 *         required: true
 *         schema:
 *           type: string
 *         description: 설정 키
 *     responses:
 *       200:
 *         description: 설정 값
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ConfigResponse'
 *       400:
 *         description: 잘못된 요청
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 */

/**
 * @swagger
 * /api/v1/config:
 *   post:
 *     summary: 설정 업데이트
 *     description: 특정 설정 키의 값을 업데이트합니다.
 *     tags: [System]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             $ref: '#/components/schemas/ConfigUpdateRequest'
 *     responses:
 *       200:
 *         description: 업데이트된 설정 값
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/ConfigUpdateResponse'
 *       400:
 *         description: 잘못된 요청
 *         content:
 *           application/json:
 *             schema:
 *               $ref: '#/components/schemas/Error'
 */

export const systemSchemas = {
    Error: {
        type: 'object',
        properties: {
            message: {
                type: 'string',
                description: '에러 메시지'
            },
            code: {
                type: 'string',
                description: '에러 코드'
            }
        }
    },
    HealthResponse: {
        type: 'object',
        properties: {
            success: {
                type: 'boolean'
            },
            status: {
                type: 'string',
                example: 'ok'
            },
            uptime: {
                type: 'number',
                description: '서버 실행 시간(초)'
            },
            timestamp: {
                type: 'string',
                format: 'date-time'
            }
        }
    },
    ConfigResponse: {
        type: 'object',
        properties: {
            success: {
                type: 'boolean'
            },
            key: {
                type: 'string'
            },
            value: {
                type: 'string'
            },
            timestamp: {
                type: 'string',
                format: 'date-time'
            }
        }
    },
    ConfigUpdateRequest: {
        type: 'object',
        required: ['key'],
        properties: {
            key: {
                type: 'string',
                description: '설정 키'
            },
            value: {
                type: 'string',
                description: '설정 값'
            }
        }
    },
    ConfigUpdateResponse: {
        type: 'object',
        properties: {
            success: {
                type: 'boolean'
            },
            key: {
                type: 'string'
            },
            value: {
                type: 'string'
            },
            result: {
                type: 'string'
            },
            timestamp: {
                type: 'string',
                format: 'date-time'
            }
        }
    }
}; 