import pg from './postgresql';
import redis from './redis';

// 데이터베이스 초기화
export async function initializeDb() {
  try {
    // PostgreSQL 스키마 초기화
    await pg.initializeSchema();
    
    // Redis 연결 테스트
    await redis.testConnection();
    
    console.log('Database initialization completed successfully');
    return true;
  } catch (error) {
    console.error('Database initialization failed:', error);
    return false;
  }
}

export { pg, redis };

export default {
  pg,
  redis,
  initializeDb,
}; 