// PostgreSQL 연결 정보 (중앙 설정에서 가져오기)
import { getDatabaseConfig } from '@/config/serverConfig';

const config = getDatabaseConfig();

// PostgreSQL Pool에 맞는 형식으로 변환
const dbConfig = {
  host: config.host,
  port: config.port,
  user: config.user,
  password: config.password,
  database: config.name, // 'name'을 'database'로 매핑
  ssl: false, // 개발환경에서는 SSL 비활성화
  max: 20, // 최대 연결 수
  idleTimeoutMillis: 30000,
  connectionTimeoutMillis: 2000,
};

export default dbConfig; 