import pg from 'pg';

const { Pool } = pg;

let pool: pg.Pool | null = null;

export function getDbConnection() {
    if (!pool) {
        pool = new Pool({
            user: process.env.POSTGRES_USER || 'ivs',
            host: process.env.POSTGRES_HOST || 'localhost',
            database: process.env.POSTGRES_DB || 'airun',
            password: process.env.POSTGRES_PASSWORD || '1234',
            port: parseInt(process.env.POSTGRES_PORT || '5433'),
            max: 20,
            idleTimeoutMillis: 30000,
            connectionTimeoutMillis: 10000,
        });
    }
    return pool;
}

export async function query(text: string, params?: any[]) {
    const pool = getDbConnection();
    return await pool.query(text, params);
}