# AI.RUN Help

## 🌟 Introduction
AI.RUN is a powerful AI agent orchestration tool that integrates and coordinates various AI models to perform real system tasks.

## 📱 How to Use

### AI Chat
The main screen where you can chat with AI and request tasks.
- **Basic Usage**
  - Enter your question or task in the chat window
  - Select AI model from the top right
  - Press send button to start conversation
- **Chat/Execution Mode**
  - Chat mode: Freely exchange information with AI
  - Execution mode: Perform direct tasks like system commands and file operations
- **Prompt Settings**
  - Customize prompts in Settings > AI Settings
  - Configure custom prompts for specific tasks
  - Optimize prompts for different types of tasks

### Settings
Manage system-wide settings.

- **AI Model Settings**
  - Select AI provider (OpenAI, Anthropic, Ollama, Gemini, Groq)
  - Register and manage API keys
  - Model selection and configuration

- **Chat Settings**
  - Command review before execution
  - Auto-execution settings
  - Theme settings (Dark/Light)
  - Language settings (Korean, English, Japanese, Chinese, Spanish, French)

- **RAG Settings**
  - RAG feature toggle
  - Document path configuration
  - Database initialization and document processing

- **SMTP Settings**
  - Mail server host
  - Port number
  - User account
  - Secure connection settings

- **Additional Features**
  - Web search usage
  - Session initialization
  - Settings reset

### AI Settings
Screen for managing prompts for AI conversation.

- **Prompt Editor**
  - View current prompt content
  - Direct prompt modification and saving
  - Reset to default available

- **RAG Prompt**
  - Special prompts for RAG functionality
  - Optimized prompts for document search and reference
  - Knowledge-based response generation settings

- **Key Features**
  - Real-time prompt saving
  - Restore default prompt
  - Apply RAG prompt
  - Prompt preview

### Task Manager
Screen for saving and managing frequently used AI tasks.
- **Task Registration Methods**
  1. Direct Registration
     - Create new task with 'New Task' button
     - Write task name and description
     - Pre-write instructions for AI
  2. Register from Chat
     - Click 'Register Task' button for successful operations
     - Add task name and description
     - Executed task content is automatically saved

- **Cached Tasks**
  - Automatically creates cached task when registering from chat
  - Quick response with stored code execution without AI calls
  - Reduces task execution costs
  - Especially useful for frequent system tasks

- **Task Management**
  - Check status and execute/stop from task list
  - Modify and delete task content
  - View execution history
  - Manage cached task updates

### Usage Analytics
Screen for checking AI model usage and costs.
- **Overall Summary**
  - Total cost and token usage
  - Monthly cost and token usage
  - Trend analysis and comparison

- **Provider Analysis**
  - Cost and token usage by AI provider
  - Request count statistics
  - Provider cost distribution chart

- **Detailed Analysis**
  - Monthly usage trends
  - Usage distribution by time
  - Token usage comparison by model
  - Cost efficiency analysis by model

- **Session Analysis**
  - Usage distribution by session
  - Initial prompt content
  - Cost and token statistics by session

- **Detailed Records**
  - AI call detailed record table
  - Time, provider, model, token, cost information
  - CSV format download support

### Execution History
Screen for checking all commands and results executed during AI conversations.
- **Execution Records**
  - Display execution time and status (success/failure)
  - User query content
  - Executed code
  - Execution results

## 🚀 Key Features

### 1. AI Agent Orchestration
- **Multi-provider Integration**
  - Utilize various AI models including OpenAI, Anthropic, Ollama, Google, Groq
  - Flexible selection between local execution (Ollama) and cloud services
  - Automatic failover support for provider issues
  - Provider selection based on cost/performance optimization

- **Prompt Optimization**
  - Provide prompt templates optimized for each model
  - Real-time token usage monitoring
  - Context compression and optimization
  - Multi-language prompt support

### 2. Document Processing and Knowledge Management
- **RAG (Retrieval-Augmented Generation)**
  - High-performance embedding based on Xenova/all-MiniLM-L6-v2 model
  - Stable vector data management with ChromaDB + SQLite combination
  - Hybrid search: semantic + keyword combined search
  - Dynamic document chunk splitting and metadata management

- **Various Document Format Support**
  - Process HWP, PDF, MS Office documents
  - Table/image extraction and processing
  - Automatic metadata extraction and tagging
  - Batch processing of large documents

### 3. System Integration and Automation
- **Task Management System**
  - Automate and schedule repetitive tasks
  - Track task execution results
  - Real-time monitoring and notifications
  - Task history management and reuse

- **System Integration**
  - Direct file system access and manipulation
  - System command execution and automation
  - Local program control
  - Automatic development environment configuration

### 4. Web and Email Integration
- **Integrated Web Search**
  - Multi-language search engine integration (Google, Naver, Daum)
  - Stable search based on Selenium
  - Automatic analysis and extraction of search results
  - Response speed optimization with cache system

- **Email Features**
  - HTML template support
  - Mass email sending
  - Attachment handling
  - Automatic email response and classification

### 5. Developer Tools
- **Code Management**
  - AST-based code analysis
  - Code generation and optimization
  - Multi-runtime support (Node.js, Python)
  - Sandbox execution environment

- **Package Management**
  - Automatic dependency resolution
  - Version compatibility check
  - Security vulnerability check
  - Virtual environment management

## 💡 Key Advantages

### 1. Cost Optimization
- **Caching System**
  - RAG search result caching (TTL: 72 hours)
  - Web search result caching
  - Embedding result caching
  - Collection information caching

- **Resource Usage Optimization**
  - Token usage monitoring
  - Cost-effective model auto-selection
  - Batch processing optimization
  - Duplicate request prevention

### 2. Performance and Stability
- **High-performance Architecture**
  - Node.js and Python hybrid structure
  - Stability through process isolation
  - Multi-thread processing
  - Memory usage optimization

- **Error Handling and Recovery**
  - Automatic retry mechanism
  - Failure recovery system
  - Detailed error logging
  - Automatic backup and recovery

### 3. Security and Compliance
- **Data Security**
  - Prevent data leakage with local environment execution
  - Automatic sensitive information detection and masking
  - Access control and permission management
  - Compliance with ISMS-P, GDPR, etc.

- **Monitoring and Audit**
  - Task execution log recording
  - Resource usage monitoring
  - Security audit reports
  - Real-time alert system

## 📊 Performance Metrics
- RAG Search Response Time
  * Cache miss: 4-5 seconds
  * Cache hit: 0.002-0.005 seconds
- Web Search Response Time
  * Initial search: 4-5 seconds
  * Cache hit: 0.001 seconds
- Document Processing Performance
  * Recommended document volume: 5,000-10,000 pages
  * Maximum processing capacity: 20,000-30,000 pages

## 📞 Technical Support
- Email: sales@invesume.com
- Website: https://invesume.com
- Phone: 02-2039-3977 / 010-3838-8378 