﻿# 바탕화면에 AI.RUN GUI 바로가기를 생성하는 PowerShell 스크립트

# 색상 정의
$Red = [System.ConsoleColor]::Red
$Green = [System.ConsoleColor]::Green
$Yellow = [System.ConsoleColor]::Yellow

# 로그 함수
function Write-ColorOutput {
    param(
        [Parameter(Mandatory = $true)]
        [string]$Message,
        [Parameter(Mandatory = $true)]
        [string]$Type
    )
    
    $Color = switch ($Type) {
        "INFO" { $Green }
        "WARN" { $Yellow }
        "ERROR" { $Red }
    }
    
    Write-Host "[$Type] " -ForegroundColor $Color -NoNewline
    Write-Host $Message
}

# 바로가기 생성
try {
    # 바탕화면 경로 가져오기
    $DesktopPath = [Environment]::GetFolderPath("Desktop")
    $ShortcutPath = Join-Path $DesktopPath "AI.RUN.lnk"

    Write-ColorOutput "바로가기 생성 중..." "INFO"

    # WScript.Shell 객체 생성
    $WScriptShell = New-Object -ComObject WScript.Shell

    # npm 전역 설치 경로 가져오기
    $NpmBinPath = Join-Path $env:APPDATA "npm"
    $AirunPath = Join-Path $NpmBinPath "airun.cmd"
    
    Write-ColorOutput "airun 경로: $AirunPath" "INFO"

    # 바로가기 생성
    $Shortcut = $WScriptShell.CreateShortcut($ShortcutPath)
    $Shortcut.TargetPath = $AirunPath
    $Shortcut.Arguments = "-g"
    $Shortcut.WindowStyle = 7  # 최소화된 창으로 실행
    $Shortcut.Description = "AI.RUN Graphical User Interface"
    
    # 아이콘 설정 (프로젝트 디렉토리의 아이콘 사용)
    $ProjectRoot = Split-Path -Parent (Split-Path -Parent $MyInvocation.MyCommand.Path)
    $IconPath = Join-Path $ProjectRoot "assets\airun.ico"
    
    if (Test-Path $IconPath) {
        $Shortcut.IconLocation = $IconPath
        Write-ColorOutput "아이콘 경로: $IconPath" "INFO"
    } else {
        # npm 전역 설치 경로에서 아이콘 찾기 시도
        $NpmPrefix = npm prefix -g
        $IconPath = Join-Path $NpmPrefix "node_modules\airun\assets\airun.ico"
        
        if (Test-Path $IconPath) {
            $Shortcut.IconLocation = $IconPath
            Write-ColorOutput "아이콘 경로: $IconPath" "INFO"
        } else {
            Write-ColorOutput "아이콘 파일을 찾을 수 없습니다." "WARN"
        }
    }

    # 바로가기 저장
    $Shortcut.Save()

    Write-ColorOutput "바로가기가 성공적으로 생성되었습니다." "INFO"
    Write-ColorOutput "위치: $ShortcutPath" "INFO"

} catch {
    Write-ColorOutput "바로가기 생성 중 오류가 발생했습니다: $_" "ERROR"
    exit 1
} 